/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/highlighting/JSRainbowVisitor", "suitableForFile"));
        }
        return file instanceof JSFile || file instanceof XmlFile;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSRainbowVisitor", "visit"));
        }
        PsiElement scope = JSPsiImplUtils.getExecutionScope(element);
        if (scope == null) {
            return;
        }
        PsiElement target = element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null ? JSStubBasedPsiTreeUtil.resolveLocally(((JSReferenceExpression)element).getReferenceName(), scope) : element;
        if (target instanceof JSVariable || target instanceof JSDefinitionExpression) {
            PsiElement highlight;
            JSNamespace namespace = scope instanceof JSElementBase ? JSNamespaceImpl.buildProvidedNamespace((JSElementBase)scope, true) : null;
            PsiElement psiElement = highlight = element instanceof JSReferenceExpression ? ((JSReferenceExpression)element).getReferenceNameElement() : ((JSQualifiedNamedElement)element).getNameIdentifier();
            if (highlight == null) {
                return;
            }
            HighlightInfo info = this.getInfo(scope, highlight, namespace + "." + highlight.getText(), this.getColorKey(element));
            this.addInfo(info);
        }
    }

    @Nullable
    protected TextAttributesKey getColorKey(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSRainbowVisitor", "getColorKey"));
        }
        if (element instanceof JSParameter) {
            return JSHighlighter.JS_PARAMETER;
        }
        if (element instanceof JSVariable) {
            return ((JSVariable)element).isLocal() ? JSHighlighter.JS_LOCAL_VARIABLE : JSHighlighter.JS_GLOBAL_VARIABLE;
        }
        return null;
    }

    @NotNull
    public HighlightVisitor clone() {
        JSRainbowVisitor jSRainbowVisitor = new JSRainbowVisitor();
        if (jSRainbowVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSRainbowVisitor", "clone"));
        }
        return jSRainbowVisitor;
    }
}

