/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.type.jsclass.JSTypeHierarchyBrowser;
import com.intellij.lang.javascript.hierarchy.type.jsfunction.JSFunctionHierarchyBrowser;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        VirtualFile file;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider", "getTarget"));
        }
        JSClass jsClass = JSTypeHierarchyProvider.getJSClass(dataContext);
        if (jsClass != null) {
            return jsClass;
        }
        JSPsiElementBase jsFunction = JSHierarchyUtils.getJSFunction(dataContext, true);
        if (jsFunction != null && jsFunction.isValid() && (file = (psiFile = jsFunction.getContainingFile()).getVirtualFile()) != null && !"swf".equalsIgnoreCase(file.getExtension()) && !(DialectDetector.languageOfElement((PsiElement)psiFile) instanceof ECMAL4LanguageDialect)) {
            return jsFunction;
        }
        return null;
    }

    @Nullable
    private static JSClass getJSClass(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
            if (targetElement instanceof JSClass) {
                return (JSClass)targetElement;
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file instanceof XmlFile) {
                Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file);
                if (injEditor != null) {
                    PsiElement injTargetElement = TargetElementUtil.findTargetElement((Editor)injEditor, (int)3);
                    if (injTargetElement instanceof JSClass) {
                        return (JSClass)injTargetElement;
                    }
                    int offset = editor.getCaretModel().getOffset();
                    PsiElement element = file.findElementAt(offset);
                    JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
                    if (jsClass != null) {
                        return jsClass;
                    }
                }
                if (JavaScriptSupportLoader.isFlexMxmFile(file) || JavaScriptSupportLoader.isBindowsFile((PsiElement)file)) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
                }
            } else if (file instanceof JSFile) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file.findElementAt(offset);
                return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
            }
        } else {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element instanceof JSClass) {
                return (JSClass)element;
            }
            if (element instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)element);
            }
            if (element instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element);
            }
        }
        return null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(final PsiElement target) {
        if (target instanceof JSClass) {
            JSTypeHierarchyBrowser jSTypeHierarchyBrowser = new JSTypeHierarchyBrowser(target.getProject(), (JSClass)target);
            if (jSTypeHierarchyBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider", "createHierarchyBrowser"));
            }
            return jSTypeHierarchyBrowser;
        }
        if (target instanceof JSNamedElement) {
            JSFunctionHierarchyBrowser jSFunctionHierarchyBrowser = new JSFunctionHierarchyBrowser(target.getProject(), (JSNamedElement)target);
            if (jSFunctionHierarchyBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider", "createHierarchyBrowser"));
            }
            return jSFunctionHierarchyBrowser;
        }
        HierarchyBrowser hierarchyBrowser = new HierarchyBrowser(){

            public JComponent getComponent() {
                return new JLabel("Not implemented. Target: " + target);
            }

            public void setContent(Content content) {
            }
        };
        if (hierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider", "createHierarchyBrowser"));
        }
        return hierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider", "browserActivated"));
        }
        if (hierarchyBrowser instanceof JSTypeHierarchyBrowser) {
            JSTypeHierarchyBrowser browser = (JSTypeHierarchyBrowser)hierarchyBrowser;
            String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
            browser.changeView(typeName);
        } else if (hierarchyBrowser instanceof JSFunctionHierarchyBrowser) {
            ((JSFunctionHierarchyBrowser)hierarchyBrowser).changeView(TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE);
        }
    }
}

