/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.yeoman;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class YeomanAppFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/yeoman/YeomanAppFileReferenceHelper", "getContexts"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                PsiDirectory directory;
                VirtualFile appDir;
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                VirtualFile packageJson = root.findChild("package.json");
                VirtualFile bowerJson = root.findChild("bower.json");
                if ((packageJson == null || !packageJson.isValid() || packageJson.isDirectory()) && (bowerJson == null || !bowerJson.isValid() || bowerJson.isDirectory()) || (appDir = YeomanAppFileReferenceHelper.findAppDir(file, root)) == null || !appDir.isValid() || !appDir.isDirectory() || (directory = PsiManager.getInstance((Project)project).findDirectory(appDir)) == null) continue;
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/yeoman/YeomanAppFileReferenceHelper", "getContexts"));
                }
                return set;
            }
        }
        Set<PsiFileSystemItem> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/yeoman/YeomanAppFileReferenceHelper", "getContexts"));
        }
        return set;
    }

    private static VirtualFile findAppDir(VirtualFile file, VirtualFile root) {
        while (file != null && !file.equals(root)) {
            if ("app".equals(file.getName())) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/yeoman/YeomanAppFileReferenceHelper", "isMine"));
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }
}

