/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementNSDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlElementDescriptor
implements XmlElementDescriptor {
    @NotNull
    private final String myName;
    @NotNull
    private final PsiElement myContext;
    private final boolean myStrict;
    @Nullable
    private final ReactXmlElementNSDescriptor myDescriptor;
    @Nullable
    private final XmlNSDescriptor myParentNSDescriptor;

    public ReactXmlElementDescriptor(@NotNull String name, @NotNull PsiElement context, @Nullable XmlNSDescriptor parentNSDescriptor, boolean isStrict) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        this.myName = name;
        this.myContext = context;
        this.myParentNSDescriptor = parentNSDescriptor;
        this.myStrict = isStrict;
        this.myDescriptor = new ReactXmlElementNSDescriptor(parentNSDescriptor, this.myContext, isStrict);
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        if (descriptor == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        return descriptor.getRootElementsDescriptors(null);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        return descriptor.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.getComponentProps(context);
        }
        return this.resolve(context, TypeScriptReactTagUtil::getXmlAttributeDescriptors, parentXmlElement -> parentXmlElement != null && !(parentXmlElement instanceof ReactXmlElementDescriptor) ? parentXmlElement.getAttributesDescriptors(context) : XmlAttributeDescriptor.EMPTY, XmlAttributeDescriptor.EMPTY, XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (context == null) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.findComponentProp(attributeName, context);
        }
        AnyXmlAttributeDescriptor notStrictValue = new AnyXmlAttributeDescriptor(attributeName);
        return (XmlAttributeDescriptor)this.resolve(context, typeScriptElement -> TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, typeScriptElement), parentXmlElement -> {
            if (!(parentXmlElement instanceof ReactXmlElementDescriptor)) {
                XmlAttributeDescriptor attributeDescriptor = parentXmlElement.getAttributeDescriptor(attributeName, context);
                return attributeDescriptor != null ? attributeDescriptor : notStrictValue;
            }
            return notStrictValue;
        }, null, notStrictValue);
    }

    @Nullable
    private static XmlAttributeDescriptor findComponentProp(@NonNls String attributeName, @NotNull XmlTag context) {
        XmlAttributeDescriptor descriptor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "findComponentProp"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context) && (descriptor = TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, TypeScriptReactComponentUtil.getGenericPropType(context))) != null) {
            return descriptor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)context);
        Ref declaration = Ref.create();
        JSClassResolver.getInstance().processNamespaceMembers(ReactXmlElementDescriptor.getPropsNamespace(context), scope, (Processor<JSPsiElementBase>)((Processor)base -> {
            if (attributeName.equals(base.getName())) {
                declaration.set(base);
            }
            return declaration.isNull();
        }));
        if (!declaration.isNull()) {
            return ReactAttributeDescriptor.create(attributeName, (PsiElement)declaration.get());
        }
        return new AnyXmlAttributeDescriptor(attributeName);
    }

    private static XmlAttributeDescriptor[] getComponentProps(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getComponentProps"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            JSType type = TypeScriptReactComponentUtil.getGenericPropType(context);
            return TypeScriptReactTagUtil.getXmlAttributeDescriptors(type);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)context);
        String namespace = ReactXmlElementDescriptor.getPropsNamespace(context);
        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findNamespaceMembers(namespace, scope);
        if (!members.isEmpty()) {
            return (XmlAttributeDescriptor[])ContainerUtil.map2Array(members, XmlAttributeDescriptor.class, base -> ReactAttributeDescriptor.create(base.getName(), (PsiElement)base));
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @NotNull
    private static String getPropsNamespace(@NotNull XmlTag context) {
        JSType type;
        JSField props;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        PsiReference reference = context.getReference();
        PsiNamedElement component = reference != null ? (PsiNamedElement)ObjectUtils.tryCast((Object)ReactXmlExtension.getElementByImport(reference.resolve()), PsiNamedElement.class) : null;
        String name = component != null && component.getName() != null ? component.getName() : context.getName();
        String namespace = name + ".props";
        if (component instanceof JSClass && (props = ((JSClass)component).findFieldByName("props")) != null && (type = props.getType()) instanceof JSNamedType) {
            namespace = type.getTypeText();
        }
        String string = namespace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        return string;
    }

    private <T> T resolve(XmlTag context, Function<TypeScriptPropertySignature, T> getTypeScriptInfo, Function<XmlElementDescriptor, T> parentDescriptorInfo, T strictEmptyValue, T notStrictEmptyValue) {
        boolean hasTypeScriptDefinitions;
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        boolean bl = hasTypeScriptDefinitions = property != null;
        if (property != null) {
            hasTypeScriptDefinitions = true;
            Object result = getTypeScriptInfo.fun((Object)property);
            if (result != null) {
                return (T)result;
            }
        }
        if (!this.myStrict) {
            if (hasTypeScriptDefinitions) {
                return strictEmptyValue;
            }
            XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context);
            if (elementDescriptor != null) {
                return (T)parentDescriptorInfo.fun((Object)elementDescriptor);
            }
            return notStrictEmptyValue;
        }
        return strictEmptyValue;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return ReactXmlExtension.isComponentName(this.myName) ? 0 : 1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        if (!this.myStrict && this.myContext instanceof XmlTag && !ReactXmlExtension.isComponentName(this.myName) && (descriptor = this.getXmlElementDescriptorFormParent((XmlTag)this.myContext)) != null && !(descriptor instanceof ReactXmlElementDescriptor) && (declaration = descriptor.getDeclaration()) != null) {
            return declaration;
        }
        return this.myContext;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getName"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    private XmlElementDescriptor getXmlElementDescriptorFormParent(@Nullable XmlTag context) {
        if (context == null || this.myParentNSDescriptor == null) {
            return null;
        }
        return this.myParentNSDescriptor.getElementDescriptor(context);
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

