/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.JSXEmmetOptions;
import com.intellij.lang.javascript.frameworks.react.JSXEmmetParser;
import com.intellij.lang.javascript.frameworks.react.JSXHtmlContextType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.xml.util.HtmlUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXZenCodingGenerator
extends XmlZenCodingGeneratorImpl {
    public boolean isMyContext(@NotNull PsiElement context, boolean wrapping) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/JSXZenCodingGenerator", "isMyContext"));
        }
        return DialectDetector.isJSX(context) && super.isMyContext(context, wrapping) || JSXHtmlContextType.isInContext(context, false);
    }

    public TemplateImpl createTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/frameworks/react/JSXZenCodingGenerator", "createTemplateByKey"));
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(key);
        if (!HtmlUtil.isSingleHtmlTag((String)key)) {
            builder.append(">$END$</").append(key).append('>');
        } else {
            builder.append("/>");
        }
        return new TemplateImpl("", builder.toString(), "");
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        JSXEmmetParser jSXEmmetParser = new JSXEmmetParser(tokens, callback, generator, surroundWithTemplate);
        if (jSXEmmetParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXZenCodingGenerator", "createParser"));
        }
        return jSXEmmetParser;
    }

    public boolean isEnabled() {
        return JSXEmmetOptions.getInstance().isEmmetEnabled();
    }

    @Nullable
    public Configurable createConfigurable() {
        return new MyConfigurable();
    }

    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/frameworks/react/JSXZenCodingGenerator", "isHtml"));
        }
        return true;
    }

    private static class MyConfigurable
    implements SearchableConfigurable {
        private JBCheckBox myEnabledCheckBox = new JBCheckBox("Enable JSX Emmet");

        private MyConfigurable() {
        }

        @NotNull
        public String getId() {
            if ("reference.idesettings.emmet.jsx" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXZenCodingGenerator$MyConfigurable", "getId"));
            }
            return "reference.idesettings.emmet.jsx";
        }

        @Nls
        public String getDisplayName() {
            return "JSX";
        }

        @Nullable
        public String getHelpTopic() {
            return this.getId();
        }

        @Nullable
        public JComponent createComponent() {
            JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
            if (this.myEnabledCheckBox != null) {
                panel.add((Component)this.myEnabledCheckBox, (Object)"North");
            }
            return panel;
        }

        public boolean isModified() {
            return this.myEnabledCheckBox != null && this.myEnabledCheckBox.isSelected() != JSXEmmetOptions.getInstance().isEmmetEnabled();
        }

        public void apply() throws ConfigurationException {
            if (this.myEnabledCheckBox != null) {
                JSXEmmetOptions.getInstance().setEmmetEnabled(this.myEnabledCheckBox.isSelected());
            }
        }

        public void reset() {
            if (this.myEnabledCheckBox != null) {
                this.myEnabledCheckBox.setSelected(JSXEmmetOptions.getInstance().isEmmetEnabled());
            }
        }

        public void disposeUIResources() {
            this.myEnabledCheckBox = null;
        }
    }
}

