/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSModuleReference
extends JSFileReference {
    private final String myNewFileTemplateName;
    private final boolean myIsSoft;

    public JSModuleReference(String text, int offset, TextRange textRange, FileReferenceSet fileReferenceSet, String newFileTemplateName, boolean isSoft) {
        super(text, offset, textRange, fileReferenceSet);
        this.myNewFileTemplateName = newFileTemplateName;
        this.myIsSoft = isSoft;
    }

    public String getNewFileTemplateName() {
        return this.myNewFileTemplateName;
    }

    public boolean isSoft() {
        return this.myIsSoft;
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem psiFileSystemItem, Collection<ResolveResult> resolveResults, boolean b) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "innerResolveInContext"));
        }
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "innerResolveInContext"));
        }
        int size = resolveResults.size();
        super.innerResolveInContext(referenceText, psiFileSystemItem, resolveResults, b);
        if (resolveResults.size() == size && psiFileSystemItem instanceof PsiDirectory) {
            if (!psiFileSystemItem.isValid()) {
                return;
            }
            this.resolveElementsMatchedNameWithoutExtension(referenceText, psiFileSystemItem, resolveResults);
        }
    }

    private void resolveElementsMatchedNameWithoutExtension(@NotNull String s, @NotNull PsiFileSystemItem psiFileSystemItem, Collection<ResolveResult> resolveResults) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "resolveElementsMatchedNameWithoutExtension"));
        }
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "resolveElementsMatchedNameWithoutExtension"));
        }
        for (PsiElement element : psiFileSystemItem.getChildren()) {
            String name;
            if (!(element instanceof PsiFile) || !this.isMatchingFile(s, name = FileUtil.getNameWithoutExtension((String)((PsiFile)element).getName()))) continue;
            resolveResults.add((ResolveResult)new PsiElementResolveResult(element));
            return;
        }
    }

    private boolean isMatchingFile(@NotNull String lookup, String name) {
        String originalName;
        String platform;
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "isMatchingFile"));
        }
        if (StringUtil.equals((CharSequence)lookup, (CharSequence)name)) {
            return true;
        }
        PsiFile file = this.getElement().getContainingFile();
        if (DialectDetector.isJSX((PsiElement)file) && ("ios".equalsIgnoreCase(platform = FileUtilRt.getExtension((String)(originalName = FileUtil.getNameWithoutExtension((String)file.getName())))) || "android".equalsIgnoreCase(platform))) {
            return StringUtil.equals((CharSequence)(lookup + "." + platform), (CharSequence)name);
        }
        return false;
    }

    protected Object createLookupItem(PsiElement candidate) {
        return JSCompletionUtil.createLookupElementForJSModule(candidate);
    }
}

