/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCommonReferenceContributor
implements JSModuleReferenceContributor {
    public static JSCommonReferenceContributor INSTANCE = new JSCommonReferenceContributor();

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        FileReference[] fileReferenceArray = new JSAmdModuleFileReferenceSet(unquotedRefText, host, offset, provider).getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        return fileReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript(host);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isRelative(String pathString) {
        return pathString.endsWith(".js") || pathString.startsWith(".");
    }

    public static void addNodeModulesDirContexts(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result, @NotNull FileReferenceSet referenceSet) {
        String firstRefText;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addNodeModulesDirContexts"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addNodeModulesDirContexts"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addNodeModulesDirContexts"));
        }
        if (referenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceSet", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addNodeModulesDirContexts"));
        }
        FileReference firstRef = (FileReference)ArrayUtil.getFirstElement((Object[])referenceSet.getAllReferences());
        String string = firstRefText = firstRef != null ? firstRef.getText() : null;
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        VirtualFile localNodeModulesDir = JSCommonReferenceContributor.findUpNodeModules(element);
        boolean addedLocal = false;
        for (VirtualFile file : files) {
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file);
            if (nodeModulesDir == null) continue;
            JSCommonReferenceContributor.doAddNodeModulesContext(nodeModulesDir, file, firstRefText, result, element.getManager());
            if (!nodeModulesDir.equals(localNodeModulesDir)) continue;
            addedLocal = true;
        }
        if (!addedLocal && localNodeModulesDir != null) {
            VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(localNodeModulesDir);
            JSCommonReferenceContributor.doAddNodeModulesContext(localNodeModulesDir, packageJson, firstRefText, result, element.getManager());
        }
        JSCommonReferenceContributor.addTypesForNodeModulesDir(element, result, localNodeModulesDir);
    }

    @Nullable
    private static VirtualFile findUpNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "findUpNodeModules"));
        }
        VirtualFile currentFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        if (currentFile != null) {
            return NodeModuleUtil.findUpClosestNodeModulesResolveRoot(currentFile);
        }
        return null;
    }

    private static void doAddNodeModulesContext(@NotNull VirtualFile nodeModulesDir, @Nullable VirtualFile packageJson, @NotNull String firstRefText, @NotNull Collection<PsiFileSystemItem> result, @NotNull PsiManager psiManager) {
        PackageJsonData data;
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "doAddNodeModulesContext"));
        }
        if (firstRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstRefText", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "doAddNodeModulesContext"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "doAddNodeModulesContext"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "doAddNodeModulesContext"));
        }
        if (packageJson != null && !(data = PackageJsonUtil.getOrCreateData(packageJson)).containsDependencyWithScope(firstRefText) && !data.isDependencyOfAnyType(firstRefText)) {
            return;
        }
        PsiDirectory directory = psiManager.findDirectory(nodeModulesDir);
        if (directory != null) {
            result.add((PsiFileSystemItem)directory);
        }
    }

    public static void addTypesForNodeModulesDir(@NotNull PsiElement context, @NotNull Collection<PsiFileSystemItem> altResolveModules, @Nullable VirtualFile nodeModulesFile) {
        PsiDirectory typesModules;
        VirtualFile typesFile;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addTypesForNodeModulesDir"));
        }
        if (altResolveModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "altResolveModules", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "addTypesForNodeModulesDir"));
        }
        if (nodeModulesFile != null && (typesFile = nodeModulesFile.findChild("@types")) != null && (typesModules = context.getManager().findDirectory(typesFile)) != null) {
            altResolveModules.add((PsiFileSystemItem)typesModules);
        }
    }

    public static class JSAmdModuleFileReferenceSet
    extends FileReferenceSet {
        public JSAmdModuleFileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "<init>"));
            }
            super(str, element, startInElement, provider, false, true, DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            boolean relative = JSCommonReferenceContributor.isRelative(this.getPathString());
            if (!relative) {
                PsiElement element = this.getElement();
                Project project = element.getProject();
                ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
                JSCommonReferenceContributor.addNodeModulesDirContexts(project, element, result, this);
                Collection<PsiDirectory> amdBaseDirectories = JSAmdUtil.getBaseDirectories(element);
                result.addAll(amdBaseDirectories);
                if (!result.isEmpty()) {
                    ArrayList<PsiFileSystemItem> arrayList = result;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "computeDefaultContexts"));
                    }
                    return arrayList;
                }
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        public FileReference createFileReference(TextRange textRange, int i, String text) {
            return new JSModuleReference(text, i, textRange, this, "AMD JavaScript File.js", !JSCommonReferenceContributor.isRelative(this.getPathString()));
        }
    }
}

