/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSDialectCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSDialectCodeStyleSettingsProvider;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlockEx;
import com.intellij.lang.javascript.formatter.blocks.JSParameterBlock;
import com.intellij.lang.javascript.formatter.blocks.JSParameterListBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptFormattingModelBuilder
implements FormattingModelBuilder {
    public static final Key<Alignment> BLOCK_ALIGNMENT = Key.create((String)"js.block.alignment");

    public static FormattingModel createJSFormattingModel(PsiFile file, CodeStyleSettings settings, Block rootBlock) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor((PsiFile)file);
        if (document != null && FormattingDocumentModelImpl.canUseDocumentModel((Document)document, (PsiFile)file) && file instanceof JSFile && file.getContext() == null) {
            return new DocumentBasedFormattingModel(rootBlock, file.getProject(), settings, file.getFileType(), file);
        }
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)rootBlock, (CodeStyleSettings)settings);
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        PsiFile psiFile = element.getContainingFile();
        Language dialect = JSLanguageUtil.getLanguageDialect((PsiElement)psiFile);
        JSBlock block = this.createSubBlock(element.getNode(), (Alignment)element.getNode().getUserData(BLOCK_ALIGNMENT), null, null, settings, dialect, null, JavascriptFormattingModelBuilder.getCustomSettings(settings, dialect));
        FormattingModel model = JavascriptFormattingModelBuilder.createJSFormattingModel(psiFile, settings, (Block)block);
        block.setPolicy(this.getPolicy(element, settings, model.getDocumentModel()));
        FormattingModel formattingModel = model;
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @NotNull
    public XmlFormattingPolicy getPolicy(PsiElement element, CodeStyleSettings settings, FormattingDocumentModel model) {
        Object object = DialectDetector.isJSX(element) ? new HtmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                if (!(tag.getParent() instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }

            public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                return false;
            }

            protected boolean isInlineTag(XmlTag tag) {
                return StringUtil.isCapitalized((String)tag.getName()) || super.isInlineTag(tag);
            }
        } : new XmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                if (!(tag.getParent() instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getPolicy"));
        }
        return object;
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    @NotNull
    public static JSCodeStyleSettings getCustomSettings(@NotNull CodeStyleSettings settings, Language dialect) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getCustomSettings"));
        }
        if (dialect instanceof JSLanguageDialect) {
            JSCodeStyleSettings jSCodeStyleSettings = ((JSDialectCodeStyleSettingsProvider)JSDialectCodeStyleSettings.INSTANCE.forLanguage(dialect)).getCustomSettings(settings);
            if (jSCodeStyleSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getCustomSettings"));
            }
            return jSCodeStyleSettings;
        }
        JSCodeStyleSettings jSCodeStyleSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        if (jSCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getCustomSettings"));
        }
        return jSCodeStyleSettings;
    }

    public JSBlock createSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createSubBlock"));
        }
        if (topSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createSubBlock"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createSubBlock"));
        }
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createSubBlock"));
        }
        IElementType childType = child.getElementType();
        if (childType == JSElementTypes.ARGUMENT_LIST) {
            return this.createParameterListBLock(child, childAlignment, childIndent, wrap, topSettings, dialect, sharedAlignmentFactory, jsCodeStyleSettings);
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null) {
            IElementType parentType = parent.getElementType();
            if (parentType == JSElementTypes.ARGUMENT_LIST) {
                if (childType != JSTokenTypes.LPAR && childType != JSTokenTypes.RPAR && childType != JSTokenTypes.COMMA) {
                    return this.createParameterBlock(child, childAlignment, childIndent, wrap, topSettings, dialect, sharedAlignmentFactory, jsCodeStyleSettings);
                }
            } else if (parentType == JSElementTypes.REFERENCE_EXPRESSION && childType == JSTokenTypes.DOT) {
                return new JSDotBlock(child, childAlignment, childIndent, wrap, topSettings, sharedAlignmentFactory, dialect, jsCodeStyleSettings);
            }
        }
        return this.createJSSubBlock(child, childAlignment, childIndent, wrap, topSettings, dialect, sharedAlignmentFactory, jsCodeStyleSettings);
    }

    @NotNull
    protected JSBlock createParameterListBLock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsSettings) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterListBLock"));
        }
        if (topSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterListBLock"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterListBLock"));
        }
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterListBLock"));
        }
        JSParameterListBlock jSParameterListBlock = new JSParameterListBlock(child, childAlignment, childIndent, wrap, topSettings, sharedAlignmentFactory, dialect, jsSettings);
        if (jSParameterListBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterListBLock"));
        }
        return jSParameterListBlock;
    }

    @NotNull
    protected JSBlock createParameterBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterBlock"));
        }
        if (topSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterBlock"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterBlock"));
        }
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterBlock"));
        }
        JSParameterBlock jSParameterBlock = new JSParameterBlock(child, childAlignment, childIndent, wrap, topSettings, sharedAlignmentFactory, dialect, jsCodeStyleSettings);
        if (jSParameterBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createParameterBlock"));
        }
        return jSParameterBlock;
    }

    @NotNull
    protected JSBlock createJSSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createJSSubBlock"));
        }
        if (topSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createJSSubBlock"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createJSSubBlock"));
        }
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createJSSubBlock"));
        }
        JSBlockEx jSBlockEx = new JSBlockEx(child, childAlignment, childIndent, wrap, topSettings, sharedAlignmentFactory, dialect, jsCodeStyleSettings);
        if (jSBlockEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createJSSubBlock"));
        }
        return jSBlockEx;
    }

    private static class JSDotBlock
    extends JSBlockEx
    implements CallChainDotBlock {
        public JSDotBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, Language dialect, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder$JSDotBlock", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder$JSDotBlock", "<init>"));
            }
            if (jsCodeStyleSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder$JSDotBlock", "<init>"));
            }
            super(node, alignment, indent, wrap, settings, sharedAlignmentFactory, dialect, jsCodeStyleSettings);
        }
    }
}

