/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsFlowSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlowJSSettingsManager
implements PersistentStateComponent<Element> {
    private static final String ENABLED = "service-enabled";
    private static final String EXE_PATH = "exe-path";
    private static final String OTHER_SERVICES_ENABLED = "other-services-enabled";
    private static final String RESOLVE_ENABLE = "annotation-enable";
    private FlowJSSettings myFlowSettings = new FlowJSSettings.Builder().build();

    @Nullable
    public Element getState() {
        FlowJSSettings settings = this.myFlowSettings;
        Element root = new Element("js-flow-settings");
        Element enabledElement = new Element(ENABLED);
        enabledElement.addContent((Content)new Text(Boolean.toString(settings.isTypeCheckingEnabled())));
        root.addContent(enabledElement);
        Element exePathElement = new Element(EXE_PATH);
        exePathElement.addContent((Content)new Text(settings.getFlowExecutablePath()));
        root.addContent(exePathElement);
        Element resolveEnableElement = new Element(RESOLVE_ENABLE);
        resolveEnableElement.addContent((Content)new Text(Boolean.toString(settings.getFlowResolveEnable())));
        root.addContent(resolveEnableElement);
        Element otherServicesEnabled = new Element(OTHER_SERVICES_ENABLED);
        otherServicesEnabled.addContent((Content)new Text(Boolean.toString(settings.isOtherServicesEnabled())));
        root.addContent(otherServicesEnabled);
        return root;
    }

    public void loadState(Element state) {
        if (state != null) {
            String exePathText;
            FlowJSSettings.Builder builder = this.myFlowSettings.createBuilder();
            Element enabledChild = state.getChild(ENABLED);
            Element exePathElement = state.getChild(EXE_PATH);
            String string = exePathText = exePathElement != null ? exePathElement.getText() : null;
            if (exePathText != null) {
                builder.setFlowExecutablePath(exePathText);
            }
            boolean isEnabled = enabledChild == null ? !StringUtil.isEmpty((String)exePathText) : Boolean.valueOf(enabledChild.getText());
            builder.setTypeCheckingEnabled(isEnabled);
            Element otherServicesEnabled = state.getChild(OTHER_SERVICES_ENABLED);
            builder.setOtherServicesEnabled(otherServicesEnabled != null ? Boolean.valueOf(otherServicesEnabled.getText()) : isEnabled);
            Element resolveEnable = state.getChild(RESOLVE_ENABLE);
            if (resolveEnable != null) {
                builder.setFlowResolveEnable(Boolean.valueOf(resolveEnable.getText()));
            }
            this.myFlowSettings = builder.build();
        }
    }

    @NotNull
    public FlowJSSettings getFlowSettings() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "getFlowSettings"));
        }
        return flowJSSettings;
    }

    public void setFlowSettings(@NotNull FlowJSSettings flowSettings) {
        if (flowSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowSettings", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "setFlowSettings"));
        }
        this.myFlowSettings = flowSettings;
    }

    public static FlowJSSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "getInstance"));
        }
        return (FlowJSSettingsManager)ServiceManager.getService((Project)project, FlowJSSettingsManager.class);
    }
}

