/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSQualifiedNamedElementRenderer<T extends JSQualifiedNamedElement>
extends PsiElementListCellRenderer<T> {
    public String getElementText(T element) {
        return element.getName();
    }

    protected String getContainerText(T element, String name) {
        return JSQualifiedNamedElementRenderer.getContainerText(element);
    }

    public static String getContainerText(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/JSQualifiedNamedElementRenderer", "getContainerText"));
        }
        String qualifiedName = JSQualifiedNamedElementRenderer.getQualifiedName(element);
        if (qualifiedName.isEmpty()) {
            PsiFile file = element.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            qualifiedName = virtualFile == null ? file.getName() : UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(element.getProject(), virtualFile);
        }
        return "( " + qualifiedName + " )";
    }

    @NotNull
    public static String getQualifiedName(@NotNull JSQualifiedNamedElement element) {
        String elementName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/JSQualifiedNamedElementRenderer", "getQualifiedName"));
        }
        String qName = element.getQualifiedName();
        if (StringUtil.equals((CharSequence)qName, (CharSequence)(elementName = element.getName())) || qName == null || elementName == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/JSQualifiedNamedElementRenderer", "getQualifiedName"));
            }
            return "";
        }
        String string = qName.substring(0, qName.length() - elementName.length() - 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/JSQualifiedNamedElementRenderer", "getQualifiedName"));
        }
        return string;
    }

    protected int getIconFlags() {
        return 0;
    }
}

