/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.findUsages.JavaScriptGroupRuleProviderBase;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usages.PsiNamedElementUsageGroupBase;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class JavaScriptFunctionGroupRuleProvider
extends JavaScriptGroupRuleProviderBase<JSFunction> {
    @Override
    protected Class<? extends JSNamedElement> getUsageClass() {
        return JSFunction.class;
    }

    @Override
    protected UsageGroup createUsageGroup(JSFunction jsFunction) {
        PsiElement context;
        String name = jsFunction.getName();
        if (name == null && (context = jsFunction.getContainingFile().getContext()) != null) {
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
            if (parent == null) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
            }
            if (parent != null) {
                return new PsiNamedElementUsageGroupBase(parent, PlatformIcons.XML_TAG_ICON);
            }
        }
        return new FunctionUsageGroup(jsFunction);
    }

    @Override
    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        UsageGroup usageGroupForElement = super.createUsageGroupForElement(psiElement);
        if (usageGroupForElement == null) {
            usageGroupForElement = (UsageGroup)ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(psiElement, jsFunctionExpression -> this.createUsageGroup((JSFunction)jsFunctionExpression));
        }
        return usageGroupForElement;
    }

    private static class FunctionUsageGroup
    extends PsiNamedElementUsageGroupBase<JSFunction> {
        private String myAnonymousName;

        public FunctionUsageGroup(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup", "<init>"));
            }
            super((PsiNamedElement)function, PlatformIcons.METHOD_ICON);
            String name = super.getPresentableName();
            if ("<anonymous>".equals(name)) {
                JSFunction current = function;
                while (current != null && this.myAnonymousName == null) {
                    current = current.getParent();
                    JSQualifiedNamedElement qualifier = null;
                    if (current instanceof JSQualifiedNamedElement) {
                        qualifier = (JSQualifiedNamedElement)current;
                    } else if (current instanceof JSAssignmentExpression) {
                        qualifier = ((JSAssignmentExpression)current).getDefinitionExpression();
                    }
                    this.myAnonymousName = qualifier != null ? name + " in " + qualifier.getQualifiedName() : null;
                }
            }
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup", "getText"));
            }
            return string;
        }

        @NotNull
        public String getPresentableName() {
            String name = super.getPresentableName();
            if ("<anonymous>".equals(name) && this.myAnonymousName != null) {
                String string = this.myAnonymousName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup", "getPresentableName"));
                }
                return string;
            }
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup", "getPresentableName"));
            }
            return string;
        }
    }
}

