/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesConfiguration;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesProvider;
import com.intellij.lang.javascript.findUsages.SuperMethodUtil;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usageView.UsageViewTypeLocation;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/findUsages/JavaScriptFindUsagesHandlerFactory", "canFindUsages"));
        }
        return JavaScriptFindUsagesProvider.canFindUsages(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/findUsages/JavaScriptFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (!forHighlightUsages) {
            PsiElement resolve;
            PsiReference propertyRef;
            XmlBackedJSClass jsClass;
            if (element instanceof JSFileImpl) {
                JSNamedElement mainDeclaredElement = ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)element));
                if (mainDeclaredElement != null) {
                    element = mainDeclaredElement;
                }
            } else if (element instanceof XmlFile && (jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element)) != null) {
                element = jsClass;
            }
            if (element instanceof JSFunction) {
                JSFunction superMethod = SuperMethodUtil.checkSuperMethod((JSFunction)element, FindBundle.message((String)"find.usages.dialog.title", (Object[])new Object[0]), FindBundle.message((String)"find.super.method.warning.action.verb", (Object[])new Object[0]));
                if (superMethod == null) {
                    return FindUsagesHandler.NULL_HANDLER;
                }
                element = superMethod;
            }
            if (!this.canFindUsages(element)) {
                return null;
            }
            if (element instanceof JSVariable && element.getParent() instanceof JSDestructuringShorthandedProperty && (propertyRef = element.getParent().getReference()) instanceof JSDestructuringPropertyReference && (resolve = propertyRef.resolve()) != null && this.canFindUsages(resolve)) {
                String description = ElementDescriptionUtil.getElementDescription((PsiElement)resolve, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
                int r = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)JSBundle.message((String)"javascript.find.usages.destructuring.target.dialog", (Object[])new Object[]{description}), (String)JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), (String)JSBundle.message((String)"javascript.destructuring.initializer", (Object[])new Object[]{description}), (String)JSBundle.message((String)"javascript.destructuring.variable.only", (Object[])new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)Messages.getQuestionIcon());
                if (r == 0) {
                    element = resolve;
                } else if (r == 2) {
                    return FindUsagesHandler.NULL_HANDLER;
                }
            }
        }
        return new JavaScriptFindUsagesHandler(element);
    }

    private static class JavaScriptFindUsagesHandler
    extends FindUsagesHandler {
        public JavaScriptFindUsagesHandler(PsiElement element) {
            super(element);
        }

        protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/findUsages/JavaScriptFindUsagesHandlerFactory$JavaScriptFindUsagesHandler", "isSearchForTextOccurrencesAvailable"));
            }
            return true;
        }

        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            FindUsagesOptions findUsagesOptions = JavaScriptFindUsagesConfiguration.getFindUsagesOptions(this.getProject(), dataContext);
            if (findUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JavaScriptFindUsagesHandlerFactory$JavaScriptFindUsagesHandler", "getFindUsagesOptions"));
            }
            return findUsagesOptions;
        }
    }
}

