/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;

public class JSUsageTypeProvider
implements UsageTypeProvider {
    public UsageType getUsageType(PsiElement element) {
        if (!(element instanceof JSReferenceExpression)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSReferenceListMember) {
            return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
        }
        if (parent instanceof JSNewExpression) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (operationSign == JSTokenTypes.INSTANCEOF_KEYWORD || operationSign == JSTokenTypes.IS_KEYWORD) {
                return UsageType.CLASS_INSTANCE_OF;
            }
            if (operationSign == JSTokenTypes.AS_KEYWORD) {
                return UsageType.CLASS_CAST_TO;
            }
        } else {
            if (parent instanceof JSImportStatement) {
                return UsageType.CLASS_IMPORT;
            }
            if (parent instanceof JSReferenceExpression) {
                PsiElement resolve = ((JSReferenceExpression)element).resolve();
                if (resolve instanceof JSClass) {
                    return UsageType.CLASS_STATIC_MEMBER_ACCESS;
                }
            } else {
                if (parent instanceof JSParameter) {
                    return parent.getParent() instanceof JSParameterList ? UsageType.CLASS_METHOD_PARAMETER_DECLARATION : UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
                }
                if (parent instanceof JSFunction) {
                    return UsageType.CLASS_METHOD_RETURN_TYPE;
                }
                if (parent instanceof JSVariable) {
                    if (JSResolveUtil.findParent(parent) instanceof JSClass) {
                        return UsageType.CLASS_FIELD_DECLARATION;
                    }
                    return UsageType.CLASS_LOCAL_VAR_DECLARATION;
                }
                if (parent instanceof TypeScriptImportStatement || parent instanceof ES6ImportedBinding || parent instanceof ES6ExportSpecifierAlias) {
                    return UsageType.CLASS_IMPORT;
                }
            }
        }
        return null;
    }
}

