/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public static final JSReadWriteAccessDetector ourInstance = new JSReadWriteAccessDetector();

    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        return element instanceof JSVariable || element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty()) || element instanceof JSDefinitionExpression;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        if (element instanceof JSVariable) {
            JSVariable var = (JSVariable)element;
            if (var.getInitializer() != null) {
                return true;
            }
            PsiElement parent = var.getParent();
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).getDeclarationStatement() == parent) {
                return true;
            }
        } else if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return false;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getReferenceAccess"));
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement _expression) {
        if (_expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_expression", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
        }
        PsiElement expression = _expression.getParent();
        if (expression != null && this.isDeclarationWriteAccess(expression) && JSResolveUtil.isSelfReference(_expression)) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        if (_expression instanceof JSDefinitionExpression) {
            expression = _expression;
        }
        if (expression instanceof JSDefinitionExpression) {
            PsiElement grandParent = expression.getParent();
            if (grandParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getOperationSign() == JSTokenTypes.EQ) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        if (expression instanceof JSPrefixExpression) {
            if (JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPrefixExpression)expression).getOperationSign())) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
        } else if (expression instanceof JSPostfixExpression && JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPostfixExpression)expression).getOperationSign())) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }

    private static boolean isIncrementOrDecrement(IElementType sign) {
        return sign == JSTokenTypes.PLUSPLUS || sign == JSTokenTypes.MINUSMINUS;
    }
}

