/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;

public class JSQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(PsiElement element) {
        PsiElement parent;
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)parent).findNameIdentifier() == element.getNode()) {
            return parent;
        }
        if (element instanceof JSReferenceExpression) {
            return element;
        }
        return null;
    }

    public String getQualifiedName(PsiElement element) {
        PsiElement resolved;
        if (element instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)element).resolve()) instanceof JSQualifiedNamedElement) {
            element = resolved;
        }
        if (element instanceof JSQualifiedNamedElement) {
            PsiElement parent = JSResolveUtil.findParent(element);
            if (parent instanceof JSClass) {
                String parentQName = ((JSClass)parent).getQualifiedName();
                if (JSResolveUtil.isConstructorFunction(element)) {
                    return parentQName;
                }
                return parentQName + "." + ((JSNamedElement)element).getName();
            }
            return ((JSQualifiedNamedElement)element).getQualifiedName();
        }
        return null;
    }

    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        int i;
        if (fqn == null || DumbService.isDumb((Project)project)) {
            return null;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
        PsiElement element = resolver.findClassByQName(fqn, searchScope);
        if (element == null && (i = fqn.lastIndexOf(46)) != -1 && (element = resolver.findClassByQName(fqn.substring(0, i), searchScope)) instanceof JSClass) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(fqn.substring(i + 1), element, new ResolveResultSink(element, fqn.substring(i + 1)));
            element.processDeclarations(processor, ResolveState.initial(), element, element);
            return processor.getResult();
        }
        return element;
    }

    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        PsiElement context;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        String shortName = fqn.substring(fqn.lastIndexOf(46) + 1);
        boolean useShortName = false;
        boolean doQualify = element instanceof JSQualifiedNamedElement && !shortName.equals(fqn) && !(JSResolveUtil.findParent(element) instanceof JSClass);
        boolean adequatePlace = false;
        if (doQualify && file != null && (adequatePlace = JSQualifiedNameProvider.canQualifyInContext(context = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset()))) && !JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(shortName, context, fqn, true)) {
            useShortName = true;
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(useShortName ? shortName : fqn));
        if (doQualify && adequatePlace) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement at = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(editor.getCaretModel().getOffset() - 1));
            JSReferenceExpression expr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)at, JSReferenceExpression.class);
            if (expr != null) {
                ImportUtils.doImport((PsiElement)expr, fqn, true);
            }
        }
    }

    private static boolean canQualifyInContext(PsiElement context) {
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        return !(parent instanceof JSLiteralExpression) && !(parent instanceof PsiComment) && parent.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }
}

