/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamepathImpl;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlTagUtilBase;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationBuilder
implements JSDocumentationProcessor {
    @NonNls
    private static final String SEE_ALSO_DOC_TOKEN = "<DL><DT><b>See also:</b></DT><DD>";
    private static Map<JSDocumentationProcessor.MetaDocType, String> SIMPLE_TAGS = new EnumMap<JSDocumentationProcessor.MetaDocType, String>(JSDocumentationProcessor.MetaDocType.class);
    private boolean myEventsStarted;
    private final SymbolInfo generationInfo;
    private ParameterInfo currentParameterInfo;
    @NonNls
    private StringBuilder result;
    private JSFunctionItem function;
    private JSPsiElementBase namedItem;
    @NotNull
    private final PsiElement myElement;
    private final PsiElement contextElement;
    private int myNewLinesPendingCount;
    private boolean myInTableRow;
    private boolean seenPre;
    private boolean seenSeeAlso;
    private StringBuilder seeAlsoSection;
    @NonNls
    private static final String BR_DELIMITER = "<BR>\n";
    private boolean stop;
    private boolean myShowNamedItem;
    private boolean seenInheritDoc;
    private boolean myExampleStarted;
    private final JSDocumentationProvider myProvider;
    private boolean myPropertyMatched;
    private static final Pattern ourTagStartPattern;
    private final ParameterInfo NULL_PARAMETER_INFO;

    protected JSDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, boolean showNamedItem, JSDocumentationProvider provider) {
        JSExpression initializer;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "<init>"));
        }
        this.myShowNamedItem = true;
        this.NULL_PARAMETER_INFO = new ParameterInfo();
        this.myShowNamedItem = showNamedItem;
        this.myElement = element;
        this.contextElement = _contextElement;
        this.myProvider = provider;
        PsiElement parent = element.getParent();
        if (element instanceof JSVariable && (initializer = ((JSVariable)element).getInitializer()) instanceof JSFunctionExpression) {
            element = initializer;
        }
        if (element instanceof JSFunctionItem) {
            this.function = (JSFunctionItem)element;
            this.generationInfo = new MethodInfo();
            JSClass containingClass = JSUtils.getMemberContainingClass(element);
            if (containingClass != null) {
                this.generationInfo.namespace = containingClass.getQualifiedName();
            }
            for (JSParameterItem parameter : this.function.getParameters()) {
                ParameterInfo paramInfo = new ParameterInfo();
                ((MethodInfo)this.generationInfo).parameterInfoMap.put(parameter.getName(), paramInfo);
                paramInfo.type = parameter.getTypeIncludingOverridden();
                paramInfo.optional = parameter.isOptional();
                JSExpression initializer2 = parameter instanceof JSParameter ? ((JSParameter)parameter).getInitializer() : null;
                paramInfo.initialValue = initializer2 != null ? initializer2.getText() : null;
            }
            ((MethodInfo)this.generationInfo).returnInfo.type = JSFunctionImpl.evaluateReturnTypeFromHierarchy(this.function);
        } else if (element instanceof JSPsiElementBase && !(element instanceof JSAttributeNameValuePair)) {
            this.namedItem = (JSPsiElementBase)element;
            this.generationInfo = new SymbolInfo();
            if (this.namedItem instanceof JSClass && parent instanceof JSPackageStatement) {
                this.generationInfo.namespace = ((JSPackageStatement)parent).getQualifiedName();
            }
        } else {
            this.generationInfo = new SymbolInfo();
        }
        this.setResult(this.generationInfo.description);
    }

    private void doAppend(@NonNls String str) {
        while (this.myNewLinesPendingCount > 0) {
            this.result.append(this.seenPre ? "\n" : BR_DELIMITER);
            --this.myNewLinesPendingCount;
        }
        if (this.seenInheritDoc && this.generationInfo instanceof MethodInfo && (this.result == ((MethodInfo)this.generationInfo).description || this.result == ((MethodInfo)this.generationInfo).returnInfo.description)) {
            return;
        }
        str = this.seenPre ? str.replace(BR_DELIMITER, "\n") : str.replaceAll("[^<][^B][^R][^>]\n", BR_DELIMITER);
        this.result.append(str);
    }

    @Override
    public boolean needsPlainCommentData() {
        return true;
    }

    @Override
    public boolean onCommentLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "onCommentLine"));
        }
        if (this.stop) {
            return false;
        }
        String trimmedLine = line.trim();
        boolean parametersStarted = false;
        boolean parametersEnded = false;
        if (this.generationInfo instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            parametersEnded = methodInfo.parameterCount == methodInfo.parameterInfoMap.size() && (this.currentParameterInfo == null || trimmedLine.length() == 0);
            boolean bl = parametersStarted = methodInfo.parameterCount > 0;
            if (parametersEnded) {
                this.currentParameterInfo = null;
            }
        }
        if (trimmedLine.length() == 0) {
            int maxSubsequentBr;
            if (this.result.length() == 0) {
                return true;
            }
            int n = maxSubsequentBr = parametersStarted && !parametersEnded ? 0 : 2;
            if (this.myNewLinesPendingCount < maxSubsequentBr) {
                ++this.myNewLinesPendingCount;
            }
            if (parametersEnded && ((MethodInfo)this.generationInfo).returnInfo.description != this.result) {
                this.setResult(this.generationInfo.description);
                this.myNewLinesPendingCount = 1;
            }
            return true;
        }
        if (line.contains("<pre>")) {
            this.seenPre = true;
        }
        if (!this.seenPre && line.indexOf(60) != -1) {
            Matcher matcher = ourTagStartPattern.matcher(line);
            int offset = 0;
            while (matcher.find()) {
                boolean isTagEnd = matcher.start(1) != matcher.end(1);
                String s = matcher.group(2);
                if ("tr".equalsIgnoreCase(s)) {
                    boolean bl = this.myInTableRow = !isTagEnd;
                }
                if (!isTagEnd && "table".equalsIgnoreCase(s)) {
                    line = line.substring(0, offset + matcher.start(0)) + "<" + s + " border='1'" + line.substring(offset + matcher.end(0));
                    offset += " border='1'".length();
                }
                if (JSDocumentationBuilder.tagNameThatDoNotNeedEscaping(s)) continue;
                line = line.substring(0, offset + matcher.start(0)) + "&lt;" + (isTagEnd ? "/" : "") + s + line.substring(offset + matcher.end(0));
                offset += "&lt;".length() - "<".length();
            }
        }
        this.doAppend(line);
        int n = this.myNewLinesPendingCount = parametersStarted && !parametersEnded || this.myInTableRow ? 0 : 1;
        if (line.contains("</pre>")) {
            this.seenPre = false;
        }
        return true;
    }

    private static boolean tagNameThatDoNotNeedEscaping(@NonNls String s) {
        return s.equalsIgnoreCase("p") || s.equalsIgnoreCase("i") || s.equalsIgnoreCase("code") || s.equalsIgnoreCase("ul") || s.equalsIgnoreCase("li") || s.equalsIgnoreCase("b") || s.equalsIgnoreCase("a") || s.equalsIgnoreCase("tt") || s.equalsIgnoreCase("table") || s.equalsIgnoreCase("tr") || s.equalsIgnoreCase("th") || s.equalsIgnoreCase("td");
    }

    private void setResult(StringBuilder builder) {
        this.result = builder;
        this.myNewLinesPendingCount = 0;
    }

    @Override
    public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType metaDocType, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
        Object qualifiedName;
        if (metaDocType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaDocType", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "onPatternMatch"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "onPatternMatch"));
        }
        if (patternMatched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "onPatternMatch"));
        }
        if ((metaDocType != JSDocumentationProcessor.MetaDocType.PARAMETER || patternMatched.indexOf(64) < 0) && metaDocType != JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && metaDocType != JSDocumentationProcessor.MetaDocType.FIELD && metaDocType != JSDocumentationProcessor.MetaDocType.DEFAULT) {
            if (this.currentParameterInfo != null) {
                this.setResult(this.generationInfo.description);
            }
            this.currentParameterInfo = null;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEFAULT) {
            boolean color = remainingLineContent.startsWith("0x") && remainingLineContent.length() == 8;
            String content = remainingLineContent.substring(color ? 2 : 0);
            ParameterInfo parameterInfo = this.getFieldInfo(matchName);
            if (parameterInfo != null) {
                parameterInfo.initialValue = content;
            } else if (this.currentParameterInfo != null) {
                this.currentParameterInfo.defaultValue = content;
            } else {
                this.result.append(JSDocumentationBuilder.buildCurrentOrDefaultValue(content, color, true, remainingLineContent));
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.SEE) {
            String linkPart;
            String displayText;
            if (!this.seenSeeAlso) {
                if (this.seeAlsoSection == null) {
                    this.seeAlsoSection = new StringBuilder();
                }
                this.seenSeeAlso = true;
                this.result = this.seeAlsoSection;
                this.result.append(SEE_ALSO_DOC_TOKEN);
            } else {
                this.result.append("</DD><DD>");
            }
            remainingLineContent = remainingLineContent.trim();
            if (remainingLineContent.startsWith("\"") && remainingLineContent.endsWith("\"")) {
                this.result.append(StringUtil.stripQuotesAroundValue((String)remainingLineContent));
                return true;
            }
            int i = remainingLineContent.indexOf(32);
            if (i == -1) {
                linkPart = displayText = remainingLineContent;
            } else {
                linkPart = remainingLineContent.substring(0, i);
                displayText = remainingLineContent.substring(i + 1, remainingLineContent.length());
            }
            if (BrowserUtil.isAbsoluteURL((String)linkPart)) {
                this.result.append("<a href=\"").append(linkPart).append("\">").append(displayText).append("</a>");
            } else if (JSDocumentationBuilder.looksLikeWebURL(linkPart)) {
                this.result.append("<a href=\"http://").append(linkPart).append("\">").append(displayText).append("</a>");
            } else {
                String link = this.myProvider.tryGetSeeAlsoLink(linkPart, this.myElement);
                if (link != null) {
                    DocumentationManager.createHyperlink((StringBuilder)this.result, (String)link, (String)displayText, (boolean)true);
                } else {
                    this.result.append(remainingLineContent);
                }
            }
        } else if (this.seenSeeAlso) {
            this.seenSeeAlso = false;
            this.result.append("</DD></DL>");
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EVENT) {
            if (this.myEventsStarted) {
                this.result.append("</DD><DD>");
            }
            this.result.append("\n");
            if (!this.myEventsStarted) {
                this.myEventsStarted = true;
                this.result.append("<DL><DT><b>Events:</b></DT><DD>");
            }
            this.result.append("Event <code>").append(matchName).append("</code> -").append(remainingLineContent);
            return true;
        }
        if (this.myEventsStarted) {
            this.myEventsStarted = false;
            this.result.append("</DD></DL>");
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EXAMPLE) {
            this.result.append("<p><b>Example:</b><p><code>");
            this.myExampleStarted = true;
        } else if (this.myExampleStarted) {
            this.myExampleStarted = false;
            this.result.append("</code>");
        }
        if (SIMPLE_TAGS.containsKey((Object)metaDocType)) {
            this.result.append(SIMPLE_TAGS.get((Object)metaDocType)).append(remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS) {
            ParameterInfo parameterInfo = this.getFieldInfo(matchName);
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            if (parameterInfo != null) {
                parameterInfo.optional = true;
                return true;
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
            this.generationInfo.deprecated = true;
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DESCRIPTION) {
            if (this.generationInfo.description.length() > 0) {
                this.generationInfo.description.append("<p>");
            }
            this.generationInfo.description.append(remainingLineContent);
            return true;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myElement, true);
        if (metaDocType == JSDocumentationProcessor.MetaDocType.PRIVATE || metaDocType == JSDocumentationProcessor.MetaDocType.PUBLIC || metaDocType == JSDocumentationProcessor.MetaDocType.PROTECTED || metaDocType == JSDocumentationProcessor.MetaDocType.STATIC) {
            String s = metaDocType.name().toLowerCase();
            this.generationInfo.visibility = this.generationInfo.visibility == null ? s : this.generationInfo.visibility + ", " + s;
            if (matchName != null) {
                this.generationInfo.type = JSTypeUtils.createType(matchName, typeSource);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPE) {
            this.generationInfo.type = JSTypeUtils.createType(matchName, typeSource);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FINAL) {
            this.generationInfo.access = "final";
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.REQUIRES) {
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.NAMESPACE) {
            this.generationInfo.namespace = matchName;
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.INHERIT_DOC) {
            if (this.myElement instanceof JSClass) {
                JSClass superClassWithComment;
                JSClass clazz = (JSClass)this.myElement;
                if (!clazz.isInterface() && (superClassWithComment = JSDocumentationBuilder.findSuperClassWithDocComment(clazz)) != null) {
                    String baseDoc = new JSDocumentationProvider(false).generateDoc((PsiElement)superClassWithComment, (PsiElement)superClassWithComment);
                    ++this.myNewLinesPendingCount;
                    this.doAppend(baseDoc);
                }
                this.stop = true;
            } else if (this.myElement instanceof JSFunction || !typeSource.isEcma()) {
                this.seenInheritDoc = true;
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD && this.namedItem != null) {
            qualifiedName = this.namedItem.getQualifiedName();
            if (qualifiedName != null && ((String)qualifiedName).endsWith("options." + matchName) && !StringUtil.isEmpty((String)remainingLineContent)) {
                if (this.generationInfo.description.length() > 0) {
                    this.generationInfo.description.append("<p>");
                }
                this.generationInfo.description.append(remainingLineContent);
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PROPERTY) {
            if (matchName != null) {
                qualifiedName = JSQualifiedNameImpl.fromQualifiedName(matchName);
                if (this.namedItem instanceof JSImplicitElement && StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    this.generationInfo.description.delete(0, this.generationInfo.description.length());
                    this.generationInfo.description.append(remainingLineContent);
                    this.generationInfo.type = JSTypeUtils.createType(matchValue, typeSource);
                    this.myPropertyMatched = true;
                    this.generationInfo.myProperties = null;
                } else if (!this.myPropertyMatched && this.namedItem != null && !StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    if (this.generationInfo.myProperties == null) {
                        this.generationInfo.myProperties = new THashMap();
                    }
                    ParameterInfo property = new ParameterInfo();
                    if (matchValue != null) {
                        property.type = JSTypeUtils.createType(matchValue, JSTypeSource.EXPLICITLY_DECLARED);
                    }
                    if (((JSQualifiedNameImpl)qualifiedName).getParent() != null) {
                        property.namespace = ((JSQualifiedNameImpl)qualifiedName).getParent().getQualifiedName();
                    }
                    property.description.append(remainingLineContent);
                    this.generationInfo.myProperties.put(((JSQualifiedNameImpl)qualifiedName).getName(), property);
                }
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPEDEF) {
            this.generationInfo.type = JSTypeUtils.createType(matchValue, typeSource);
        }
        if (this.function != null) {
            SymbolInfo info;
            MethodInfo methodGenerationInfo = (MethodInfo)this.generationInfo;
            if (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS || metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                info = new SymbolInfo();
                (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS ? methodGenerationInfo.throwsInfos : methodGenerationInfo.firesInfos).add(info);
                this.result = info.description;
                if (matchName != null) {
                    if (metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                        info.addEventPrefix = true;
                    }
                    info.type = JSTypeUtils.createType(matchName, typeSource);
                }
                if (remainingLineContent != null) {
                    this.result.append(remainingLineContent);
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR) {
                methodGenerationInfo.methodType = "constructor";
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.METHOD) {
                methodGenerationInfo.methodType = "method";
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD) {
                String parameterName;
                ParameterInfo info2;
                if (matchName != null && matchName.indexOf(46) > 0 && (info2 = methodGenerationInfo.parameterInfoMap.get(parameterName = matchName.substring(0, matchName.indexOf(".")))) != null) {
                    this.currentParameterInfo = info2;
                }
                if (this.currentParameterInfo != null) {
                    String fieldName;
                    if (this.currentParameterInfo.optionsMap == null) {
                        this.currentParameterInfo.optionsMap = new LinkedHashMap<String, ParameterInfo>();
                    }
                    if ((fieldName = JSDocumentationBuilder.getFieldName(matchName)) != null) {
                        ParameterInfo parameterInfo = new ParameterInfo();
                        parameterInfo.description.append(remainingLineContent);
                        JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, typeSource);
                        parameterInfo.type = parameterType != null ? parameterType.getType() : null;
                        parameterInfo.optional = parameterType != null && parameterType.isOptional();
                        this.setResult(parameterInfo.description);
                        this.currentParameterInfo.optionsMap.put(fieldName, parameterInfo);
                    }
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                info = methodGenerationInfo.parameterInfoMap.get(matchName);
                if (info != null) {
                    SymbolInfo symbolInfo;
                    int index = 0;
                    Iterator<ParameterInfo> parameterType = methodGenerationInfo.parameterInfoMap.values().iterator();
                    while (parameterType.hasNext() && info != (symbolInfo = (SymbolInfo)parameterType.next())) {
                        ++index;
                    }
                    methodGenerationInfo.parameterCount = index + 1;
                } else if (patternMatched.indexOf(64) != -1) {
                    ++methodGenerationInfo.parameterCount;
                    int index = 0;
                    for (SymbolInfo symbolInfo : methodGenerationInfo.parameterInfoMap.values()) {
                        if (index + 1 == methodGenerationInfo.parameterCount) {
                            info = (ParameterInfo)symbolInfo;
                            break;
                        }
                        ++index;
                    }
                }
                if (info != null) {
                    ((ParameterInfo)info).name = matchName;
                    this.setResult(((ParameterInfo)info).description);
                    ((ParameterInfo)info).description.append(remainingLineContent);
                    this.currentParameterInfo = info;
                } else {
                    this.onCommentLine(line);
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.RETURN) {
                JSType typeFromCommentsFunction;
                DialectOptionHolder holder;
                this.result = methodGenerationInfo.returnInfo.description;
                boolean addReturnTypeInfoFromComments = true;
                if (this.function instanceof JSFunction && (holder = DialectDetector.dialectOfElement((PsiElement)this.function)) != null && (holder.isTypeScript || holder.isECMA4) && (typeFromCommentsFunction = JSPsiImplUtils.getTypeFromDeclaration((JSElement)this.function)) != null && !typeFromCommentsFunction.getTypeText().equals(matchName)) {
                    addReturnTypeInfoFromComments = false;
                }
                if (matchName != null) {
                    if (addReturnTypeInfoFromComments) {
                        methodGenerationInfo.returnInfo.type = JSTypeUtils.createType(matchName, typeSource);
                    } else {
                        methodGenerationInfo.returnInfo.description.append(matchName).append(" ");
                    }
                }
                if (matchValue != null) {
                    methodGenerationInfo.returnInfo.description.append(matchValue);
                }
                if (remainingLineContent != null) {
                    methodGenerationInfo.returnInfo.description.append(remainingLineContent);
                }
            }
        } else if (!(metaDocType != JSDocumentationProcessor.MetaDocType.PARAMETER || this.myElement instanceof JSImplicitElement && ((JSImplicitElement)this.myElement).getType() == JSImplicitElement.Type.Property)) {
            this.onCommentLine(line);
        }
        return true;
    }

    private static boolean looksLikeWebURL(String linkPart) {
        return linkPart.startsWith("www.") && linkPart.matches("[a-z0-9\\./]+");
    }

    @Override
    public void postProcess() {
        if (this.seenInheritDoc && this.generationInfo instanceof MethodInfo) {
            final MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            new Processor<JSFunction>(){

                public boolean process(JSFunction function) {
                    PsiComment e;
                    if (function != JSDocumentationBuilder.this.myElement && (e = JSDocumentationUtils.findDocComment(function.getNavigationElement())) != null) {
                        JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)function, (PsiElement)function, true, JSDocumentationBuilder.this.myProvider);
                        JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                        MethodInfo superMethodInfo = (MethodInfo)builder.generationInfo;
                        if (superMethodInfo.description.length() > 0) {
                            if (methodInfo.description.length() > 0) {
                                boolean addTwoBreaks = methodInfo.description.lastIndexOf(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER) != methodInfo.description.length() - JSDocumentationBuilder.BR_DELIMITER.length();
                                methodInfo.description.append(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER);
                                if (addTwoBreaks) {
                                    methodInfo.description.append(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER);
                                }
                            }
                            methodInfo.description.append((CharSequence)superMethodInfo.description);
                        }
                        int index = 0;
                        ParameterInfo[] parameterInfosArray = superMethodInfo.parameterInfoMap.values().toArray(new ParameterInfo[superMethodInfo.parameterInfoMap.size()]);
                        for (Map.Entry<String, ParameterInfo> entry : methodInfo.parameterInfoMap.entrySet()) {
                            if (entry.getValue().description.length() == 0) {
                                ParameterInfo info = superMethodInfo.parameterInfoMap.get(entry.getKey());
                                if (info != null) {
                                    entry.getValue().description.append((CharSequence)info.description);
                                } else if (index < parameterInfosArray.length) {
                                    entry.getValue().description.append((CharSequence)parameterInfosArray[index].description);
                                }
                            }
                            ++index;
                        }
                        if (methodInfo.returnInfo.description.length() == 0) {
                            methodInfo.returnInfo.description.append((CharSequence)superMethodInfo.returnInfo.description);
                        }
                        return false;
                    }
                    for (JSFunction f : JSInheritanceUtil.findImplementedMethods(function)) {
                        if (this.process(f)) continue;
                        return false;
                    }
                    for (JSPsiElementBase m : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function, true)) {
                        JSFunctionItem f = JSPsiImplUtils.calculatePossibleFunction((PsiElement)m);
                        if (!(f instanceof JSFunction) || this.process((JSFunction)f)) continue;
                        return false;
                    }
                    return true;
                }
            }.process((JSFunction)this.myElement);
        } else if (this.seenInheritDoc && this.myElement instanceof JSPsiElementBase) {
            Collection<JSPsiElementBase> members = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)this.myElement, false);
            for (JSPsiElementBase member : members) {
                PsiComment e = JSDocumentationUtils.findDocComment((PsiElement)member);
                if (e == null) continue;
                JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)member, (PsiElement)member, true, this.myProvider);
                JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                SymbolInfo superMemberInfo = builder.generationInfo;
                if (superMemberInfo.description.length() <= 0) continue;
                if (this.generationInfo.description.length() > 0) {
                    boolean addTwoBreaks = this.generationInfo.description.lastIndexOf(this.seenPre ? "\n" : BR_DELIMITER) != this.generationInfo.description.length() - BR_DELIMITER.length();
                    this.generationInfo.description.append(this.seenPre ? "\n" : BR_DELIMITER);
                    if (addTwoBreaks) {
                        this.generationInfo.description.append(this.seenPre ? "\n" : BR_DELIMITER);
                    }
                }
                this.generationInfo.description.append((CharSequence)superMemberInfo.description);
            }
        }
    }

    @Nullable
    private static JSClass findSuperClassWithDocComment(JSClass clazz) {
        PsiComment e;
        JSClass[] superClasses = clazz.getSuperClasses();
        if (superClasses.length == 1 && !JSResolveUtil.isObjectClass(superClasses[0]) && (e = JSDocumentationUtils.findDocComment((PsiElement)superClasses[0])) != null) {
            return superClasses[0];
        }
        return null;
    }

    @Nullable
    private ParameterInfo getFieldInfo(String name) {
        Map<String, ParameterInfo> map;
        String fieldName = JSDocumentationBuilder.getFieldName(name);
        if (fieldName == null) {
            return null;
        }
        Map<String, ParameterInfo> map2 = map = this.currentParameterInfo != null ? this.currentParameterInfo.optionsMap : null;
        if (map == null) {
            return this.NULL_PARAMETER_INFO;
        }
        ParameterInfo parameterInfo = map.get(fieldName);
        return parameterInfo != null ? parameterInfo : this.NULL_PARAMETER_INFO;
    }

    private static String getFieldName(String name) {
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    private static String buildCurrentOrDefaultValue(String remainingLineContent, boolean color, boolean defaultValue, String originalText) {
        remainingLineContent = color ? "<code>" + originalText + "</code><span style=\"background-color:#" + remainingLineContent + "\">&nbsp;&nbsp;&nbsp;</span>" : "<code>" + remainingLineContent + "</code>";
        return "<p>\n<u>" + (defaultValue ? "Default" : "Current") + " value:</u>&nbsp;" + remainingLineContent + "</p>";
    }

    @Nullable
    String getDoc() {
        String text;
        if (this.seenSeeAlso) {
            this.seenSeeAlso = false;
            this.seeAlsoSection.append("</DD></DL>");
        }
        this.result = new StringBuilder();
        if (this.function != null) {
            this.startFunction(this.function);
            this.result.append(this.generationInfo.description.toString());
            this.result.append("\n<DL>");
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            if (methodInfo.parameterInfoMap.size() > 0) {
                this.startNamedSection(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]));
            }
            boolean firstParameter = true;
            boolean previousHasOptionsMap = false;
            for (Map.Entry<String, ParameterInfo> parameterInfoEntry : methodInfo.parameterInfoMap.entrySet()) {
                ParameterInfo parameterInfo = parameterInfoEntry.getValue();
                if (!firstParameter && previousHasOptionsMap) {
                    this.startNamedSection("");
                }
                previousHasOptionsMap = parameterInfo.optionsMap != null;
                firstParameter = false;
                JSDocumentationBuilder.appendConfigOptionsInfoIfNeeded(parameterInfo);
                String description = parameterInfo.description.toString();
                if (parameterInfo.defaultValue != null) {
                    description = description + JSDocumentationBuilder.buildCurrentOrDefaultValue(parameterInfo.defaultValue, false, true, null);
                }
                this.appendSingleNamedDescriptionSection(parameterInfoEntry.getKey(), description);
            }
            if (methodInfo.returnInfo.description.length() > 0) {
                this.startNamedSection(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]));
                this.result.append("<DD>");
                this.result.append(methodInfo.returnInfo.description.toString());
                this.result.append("</DD>");
            }
            this.appendNamedSectionAndElements(methodInfo.throwsInfos, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]));
            this.appendNamedSectionAndElements(methodInfo.firesInfos, JSBundle.message((String)"js.documentation.fires", (Object[])new Object[0]));
            this.result.append("</DL>");
        } else {
            boolean typeWasAdded;
            if (this.namedItem != null && this.myShowNamedItem) {
                this.startNamedItem(this.namedItem.getName());
                this.endNamedItem();
            }
            this.result.append(this.generationInfo.description.toString());
            boolean bl = typeWasAdded = this.namedItem != null && this.myShowNamedItem && this.generationInfo.hasType();
            if (!typeWasAdded && this.generationInfo.hasType()) {
                this.result.append("<DL>");
                this.startNamedSection("Type:");
                this.appendSingleNamedDescriptionSection(this.generationInfo.getTypeString(false), "");
                this.result.append("</DL>");
            } else if (!typeWasAdded && this.generationInfo.type != null) {
                this.result.append("<DL>");
                this.startNamedSection("Inferred type:");
                this.appendSingleNamedDescriptionSection(this.generationInfo.getTypeString(false), "");
                this.result.append("</DL>");
            }
            if (this.generationInfo.myProperties != null) {
                this.result.append((CharSequence)JSDocumentationBuilder.buildOptionsText(this.generationInfo.myProperties, "Properties"));
            }
        }
        if (this.contextElement != null && !(this.contextElement instanceof JSImplicitElement) && (text = this.contextElement.getText()).startsWith("#") && text.length() == 7) {
            this.result.append(JSDocumentationBuilder.buildCurrentOrDefaultValue(text.substring(1), true, false, text));
        }
        if (this.seeAlsoSection != null) {
            this.result.append((CharSequence)this.seeAlsoSection);
        }
        return this.result.length() > 0 ? this.result.toString() : null;
    }

    private void appendNamedSectionAndElements(@NotNull Collection<SymbolInfo> infos, @NotNull String sectionName) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "appendNamedSectionAndElements"));
        }
        if (sectionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionName", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "appendNamedSectionAndElements"));
        }
        if (!infos.isEmpty()) {
            this.startNamedSection(sectionName);
            for (SymbolInfo mi : infos) {
                if (mi.hasType()) {
                    this.appendSingleNamedDescriptionSection(mi.getTypeString(false), mi.description.toString());
                    continue;
                }
                this.result.append("<DD>");
                this.result.append(mi.description.toString());
                this.result.append("</DD>");
            }
        }
    }

    private static void appendConfigOptionsInfoIfNeeded(ParameterInfo parameterInfo) {
        if (parameterInfo.optionsMap != null) {
            StringBuilder builder = JSDocumentationBuilder.buildOptionsText(parameterInfo.optionsMap, "Config options");
            JSDocumentationBuilder.insertParameterInfoDescription(parameterInfo.description, builder);
        }
    }

    @NotNull
    private static StringBuilder buildOptionsText(@NotNull Map<String, ParameterInfo> optionsMap, @NotNull String header) {
        if (optionsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsMap", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "buildOptionsText"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "buildOptionsText"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n<DL>");
        boolean first = true;
        JSDocumentationBuilder.startNamedSection(header + ":", builder);
        builder.append("\n</DL>");
        for (Map.Entry<String, ParameterInfo> field : optionsMap.entrySet()) {
            if (!first) {
                builder.append("<br>");
            }
            first = false;
            JSDocumentationBuilder.appendOptionDescription(field, builder);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder", "buildOptionsText"));
        }
        return stringBuilder;
    }

    private static void insertParameterInfoDescription(StringBuilder description, StringBuilder builder) {
        int i = description.indexOf(SEE_ALSO_DOC_TOKEN);
        if (i != -1) {
            description.insert(i, builder);
        } else {
            description.append((CharSequence)builder);
        }
    }

    private void startNamedSection(String sectionName) {
        JSDocumentationBuilder.startNamedSection(sectionName, this.result);
    }

    private static void startNamedSection(String sectionName, StringBuilder result) {
        result.append("<DT><b>");
        result.append(sectionName);
        result.append("</b></DT>");
    }

    private void appendSingleNamedDescriptionSection(String name, String description) {
        this.result.append("<DD><code>");
        this.result.append(name);
        this.result.append("</code>");
        if (description.length() > 0) {
            this.result.append(" - ");
            this.result.append(description);
        }
        this.result.append("</DD>\n");
    }

    public String getParameterDoc(String name) {
        if (this.function != null) {
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            ParameterInfo parameterInfo = methodInfo.parameterInfoMap.get(name);
            if (parameterInfo != null && parameterInfo.hasSomeInfo()) {
                this.result = new StringBuilder();
                this.startNamedItem(name, parameterInfo);
                this.endNamedItem();
                JSDocumentationBuilder.appendConfigOptionsInfoIfNeeded(parameterInfo);
                this.result.append(parameterInfo.description.toString());
                return this.result.toString();
            }
        }
        return null;
    }

    private static void appendOptionDescription(Map.Entry<String, ParameterInfo> e, StringBuilder builder) {
        JSDocumentationBuilder.appendParameterInfoInSignature(e, builder);
        builder.append(" - ");
        builder.append(e.getValue().description.toString());
    }

    private void startFunction(JSFunctionItem function) {
        String functionName = JSPsiImplUtils.findFunctionName(function);
        PsiElement parent = function.getParent();
        if (parent instanceof JSAssignmentExpression) {
            JSExpression qualifierExpression;
            String unqualifiedFunctionName = functionName;
            JSExpression expression = ((JSDefinitionExpression)((JSAssignmentExpression)parent).getLOperand()).getExpression();
            functionName = null;
            if (expression instanceof JSReferenceExpression && (qualifierExpression = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) {
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifierExpression);
                functionName = (ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : qualifierExpression.getText()) + "." + unqualifiedFunctionName;
            }
            if (functionName == null) {
                functionName = expression.getText();
            }
            if (this.generationInfo.namespace != null && functionName.equals(this.generationInfo.namespace + "." + unqualifiedFunctionName)) {
                this.generationInfo.namespace = null;
            }
        }
        if (functionName == null) {
            functionName = "<anonymous>";
        }
        int indent = this.startNamedItem(functionName);
        this.result.append("(");
        int resultLength = this.result.length();
        for (Map.Entry<String, ParameterInfo> parameterInfo : ((MethodInfo)this.generationInfo).parameterInfoMap.entrySet()) {
            if (this.result.length() != resultLength) {
                this.result.append(",\n");
                for (int i = 0; i < indent; ++i) {
                    this.result.append(" ");
                }
            }
            this.result.append("&nbsp;");
            JSDocumentationBuilder.appendParameterInfoInSignature(parameterInfo, this.result);
        }
        this.result.append("&nbsp;)\n");
        this.endNamedItem();
    }

    private static void appendParameterInfoInSignature(Map.Entry<String, ParameterInfo> parameterInfo, StringBuilder result) {
        boolean optional = parameterInfo.getValue().optional;
        if (parameterInfo.getValue().hasType()) {
            result.append("[ ");
            result.append(parameterInfo.getValue().getTypeString(optional));
            result.append(" ] ");
        } else if (optional) {
            result.append("[ ");
            result.append("optional");
            result.append(" ] ");
        }
        if (!StringUtil.isEmpty((String)parameterInfo.getValue().namespace)) {
            result.append(parameterInfo.getValue().namespace).append('.');
        }
        result.append(parameterInfo.getKey());
        String initialValue = parameterInfo.getValue().initialValue;
        if (initialValue != null) {
            result.append(" = ").append(initialValue);
        }
    }

    private void endNamedItem() {
        this.result.append("</PRE>");
    }

    private int startNamedItem(String functionName) {
        return this.startNamedItem(functionName, this.generationInfo);
    }

    private int startNamedItem(String functionName, SymbolInfo generationInfo) {
        this.result.append("<PRE>");
        StringBuffer options = new StringBuffer();
        Ref escapingLength = Ref.create((Object)this.result.length());
        if (generationInfo instanceof MethodInfo) {
            String type;
            JSDocumentationBuilder.addVisibilityAndAccess(options, generationInfo);
            if (((MethodInfo)generationInfo).returnInfo.hasType()) {
                if (options.length() > 0) {
                    options.append(", ");
                }
                options.append(((MethodInfo)generationInfo).returnInfo.getTypeString(false, (Ref<Integer>)escapingLength));
            }
            if ((type = ((MethodInfo)generationInfo).methodType) != null) {
                if (options.length() > 0) {
                    options.append(", ");
                }
                options.append(type);
            }
        } else {
            if (generationInfo.hasType()) {
                if (options.length() > 0) {
                    options.append(", ");
                }
                options.append(generationInfo.getTypeString(false, (Ref<Integer>)escapingLength));
            }
            JSDocumentationBuilder.addVisibilityAndAccess(options, generationInfo);
        }
        if (options.length() > 0) {
            this.result.append("[ ");
            this.result.append(options.toString());
            this.result.append(" ] ");
        }
        this.result.append("<b>");
        escapingLength.set((Object)((Integer)escapingLength.get() + 3));
        if (!StringUtil.isEmpty((String)generationInfo.namespace)) {
            this.result.append(generationInfo.namespace).append('.');
        }
        this.result.append(functionName);
        int offset = this.result.length() - (Integer)escapingLength.get() + 1;
        this.result.append("</b>");
        return offset;
    }

    private static void addVisibilityAndAccess(StringBuffer options, SymbolInfo generationInfo) {
        if (generationInfo.visibility != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.visibility);
        }
        if (generationInfo.access != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.access);
        }
        if (generationInfo.deprecated) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append("deprecated");
        }
    }

    public boolean addEvaluatedType() {
        if (this.generationInfo.type == null) {
            JSType type;
            JSType declaredType = JSTypeUtils.getTypeOfElement(this.myElement);
            if (declaredType != null) {
                this.generationInfo.type = declaredType;
                return true;
            }
            JSExpression expressionForTypeEvaluation = JSPsiImplUtils.getAssignedExpression(this.myElement);
            if (expressionForTypeEvaluation != null && !(expressionForTypeEvaluation instanceof JSFunctionExpression) && (type = JSResolveUtil.getExpressionJSType(expressionForTypeEvaluation)) != null && !(type instanceof JSAnyType)) {
                if (type.getSource().isExplicitlyDeclared()) {
                    type = JSTypeUtils.copyWithExplicitlyDeclaredRecursive(type, false);
                }
                this.generationInfo.type = type;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.NOTE, "\n<p><b>Note:</b> ");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.AUTHOR, "\n<p><b>Author:</b> ");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.FILE_OVERVIEW, "\n<p><b>File overview:</b> ");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.SINCE, "\n<p><b>Since:</b> ");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.VERSION, "\n<p><b>Version:</b> ");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.TODO, "\n<p><b>To do:</b> ");
        ourTagStartPattern = Pattern.compile("<(/)?(\\w+)");
    }

    private static class ParameterInfo
    extends SymbolInfo {
        boolean optional;
        String initialValue;
        String defaultValue;
        String name;
        Map<String, ParameterInfo> optionsMap;

        private ParameterInfo() {
        }

        boolean hasSomeInfo() {
            return this.description.length() > 0 || this.optional || this.hasType();
        }
    }

    private static class MethodInfo
    extends SymbolInfo {
        String methodType;
        Map<String, ParameterInfo> parameterInfoMap = new LinkedHashMap<String, ParameterInfo>();
        int parameterCount = 0;
        SymbolInfo returnInfo = new SymbolInfo();
        Set<SymbolInfo> throwsInfos = new LinkedHashSet<SymbolInfo>();
        List<SymbolInfo> firesInfos = new SmartList();

        private MethodInfo() {
        }
    }

    private static class SymbolInfo {
        String visibility;
        StringBuilder description = new StringBuilder();
        @Nullable
        JSType type;
        String access;
        boolean deprecated;
        String namespace;
        @Nullable
        Map<String, ParameterInfo> myProperties;
        boolean addEventPrefix;

        private SymbolInfo() {
        }

        String getTypeString(boolean optional) {
            return this.getTypeString(optional, (Ref<Integer>)Ref.create((Object)0));
        }

        @NotNull
        String getTypeString(boolean optional, final @NotNull Ref<Integer> escapingLength) {
            String unescapedTypeWithLinks;
            if (escapingLength == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapingLength", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo", "getTypeString"));
            }
            JSType type = this.type;
            if (type != null) {
                type = JSTypeUtils.applyCompositeMapping(type, new Function<JSType, JSType>(){

                    public JSType fun(JSType type) {
                        if (type instanceof JSTypeImpl) {
                            StringBuilder builder = new StringBuilder("^^");
                            JSNamepathImpl name = JSNamepathImpl.fromNamepath(type.getTypeText());
                            this.appendNamepath(name, builder, true, (Ref<Integer>)escapingLength);
                            builder.append("^^");
                            return JSNamedType.createType(builder.toString(), type.getSource(), ((JSTypeImpl)type).isStaticOrInstance());
                        }
                        return type;
                    }

                    private void appendNamepath(@NotNull JSNamepathImpl name, @NotNull StringBuilder builder, boolean outer, Ref<Integer> escapingLength2) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo$1", "appendNamepath"));
                        }
                        if (builder == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo$1", "appendNamepath"));
                        }
                        JSNamepathImpl parent = name.getParent();
                        if (parent != null) {
                            this.appendNamepath(parent, builder, false, escapingLength2);
                            builder.append(parent.getForcedContextChar());
                        }
                        String presentableName = name.getName();
                        if (outer && addEventPrefix) {
                            name = name.withName("event:" + presentableName);
                        }
                        int length = builder.length();
                        DocumentationManager.createHyperlink((StringBuilder)builder, (String)name.getQualifiedName(), (String)presentableName, (boolean)true);
                        escapingLength2.set((Object)((Integer)escapingLength2.get() + builder.length() - length - presentableName.length()));
                    }
                });
            }
            String string = unescapedTypeWithLinks = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "any";
            if (optional) {
                unescapedTypeWithLinks = unescapedTypeWithLinks + ", optional";
            }
            StringBuilder escapedBuilder = new StringBuilder();
            boolean needEscaping = !unescapedTypeWithLinks.startsWith("^^");
            for (String typePart : StringUtil.split((String)unescapedTypeWithLinks, (String)"^^")) {
                if (needEscaping) {
                    String escapedPart = XmlTagUtilBase.escapeString((String)typePart, (boolean)false);
                    escapingLength.set((Object)((Integer)escapingLength.get() + escapedPart.length() - typePart.length()));
                    typePart = escapedPart;
                }
                escapedBuilder.append(typePart);
                needEscaping = !needEscaping;
            }
            String string2 = escapedBuilder.toString();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo", "getTypeString"));
            }
            return string2;
        }

        boolean hasType() {
            if (this.type == null) {
                return false;
            }
            JSTypeSource source = this.type.getSource();
            return source.isExplicitlyDeclared();
        }
    }
}

