/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.index.JSCustomIndexer;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.util.JSPsiHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDialectSpecificHandlersFactory {
    public static final LanguageExtension<JSDialectSpecificHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.dialectSpecificHandlersFactory");
    private static final JSDialectSpecificHandlersFactory DEFAULT_INSTANCE = new JSDialectSpecificHandlersFactory();

    @NotNull
    public static JSDialectSpecificHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        JSDialectSpecificHandlersFactory jSDialectSpecificHandlersFactory = JSDialectSpecificHandlersFactory.forLanguage(dialect);
        if (jSDialectSpecificHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "forElement"));
        }
        return jSDialectSpecificHandlersFactory;
    }

    @NotNull
    public static JSDialectSpecificHandlersFactory forLanguage(@Nullable Language dialect) {
        JSDialectSpecificHandlersFactory dialectSpecificFactory = dialect != null ? (JSDialectSpecificHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSDialectSpecificHandlersFactory jSDialectSpecificHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSDialectSpecificHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "forLanguage"));
        }
        return jSDialectSpecificHandlersFactory;
    }

    @NotNull
    public JSTypeEvaluator newTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        TypeScriptTypeEvaluator typeScriptTypeEvaluator = new TypeScriptTypeEvaluator(context, processor, ecma);
        if (typeScriptTypeEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "newTypeEvaluator"));
        }
        return typeScriptTypeEvaluator;
    }

    @NotNull
    public ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        ExpectedTypeEvaluator expectedTypeEvaluator = new ExpectedTypeEvaluator(parent);
        if (expectedTypeEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "newExpectedTypeEvaluator"));
        }
        return expectedTypeEvaluator;
    }

    @Nullable
    public static JSType findExpectedType(@NotNull JSExpression parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "findExpectedType"));
        }
        return JSDialectSpecificHandlersFactory.forElement((PsiElement)parent).newExpectedTypeEvaluator(parent).findExpectedType();
    }

    @NotNull
    public JSFileCachedDataEvaluator newFileCachedDataEvaluator(JSFileCachedData outCachedData) {
        JSFileCachedDataEvaluator jSFileCachedDataEvaluator = new JSFileCachedDataEvaluator(outCachedData);
        if (jSFileCachedDataEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "newFileCachedDataEvaluator"));
        }
        return jSFileCachedDataEvaluator;
    }

    @NotNull
    public JSResolveUtil.Resolver<JSReferenceExpressionImpl> createReferenceExpressionResolver(JSReferenceExpressionImpl referenceExpression, PsiFile containingFile) {
        JSReferenceExpressionResolver jSReferenceExpressionResolver = new JSReferenceExpressionResolver(referenceExpression, containingFile);
        if (jSReferenceExpressionResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createReferenceExpressionResolver"));
        }
        return jSReferenceExpressionResolver;
    }

    @Nullable
    public JSLookupPriority getSpecificCompletionVariantPriority(PsiElement element) {
        return null;
    }

    @NotNull
    public JSClassResolver getClassResolver() {
        JSClassResolver jSClassResolver = JSClassResolver.getInstance();
        if (jSClassResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "getClassResolver"));
        }
        return jSClassResolver;
    }

    @NotNull
    public JSImportHandler getImportHandler() {
        JSImportHandler jSImportHandler = JSImportHandler.getInstance();
        if (jSImportHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "getImportHandler"));
        }
        return jSImportHandler;
    }

    @NotNull
    public QualifiedItemProcessor<? extends ResultSink> createCompletionItemProcessor(ResultSink sink, PsiFile file) {
        QualifiedItemProcessor<ResultSink> qualifiedItemProcessor = new QualifiedItemProcessor<ResultSink>(sink, file);
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createCompletionItemProcessor"));
        }
        return qualifiedItemProcessor;
    }

    @NotNull
    public JSTypeHelper getTypeHelper() {
        JSTypeHelper jSTypeHelper = JSTypeHelper.getInstance();
        if (jSTypeHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "getTypeHelper"));
        }
        return jSTypeHelper;
    }

    @NotNull
    public JSCustomIndexer createCustomIndexer(@NotNull PsiFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createCustomIndexer"));
        }
        if (indexBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexBuilder", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createCustomIndexer"));
        }
        JSCustomIndexer jSCustomIndexer = new JSCustomIndexer(file, indexBuilder);
        if (jSCustomIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createCustomIndexer"));
        }
        return jSCustomIndexer;
    }

    @NotNull
    public AccessibilityProcessingHandler createAccessibilityProcessingHandler(@Nullable PsiElement place, boolean skipNsResolving) {
        AccessibilityProcessingHandler accessibilityProcessingHandler = new AccessibilityProcessingHandler(place);
        if (accessibilityProcessingHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createAccessibilityProcessingHandler"));
        }
        return accessibilityProcessingHandler;
    }

    @NotNull
    public JSPsiHelper getPsiHelper() {
        JSPsiHelper jSPsiHelper = JSPsiHelper.INSTANCE;
        if (jSPsiHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "getPsiHelper"));
        }
        return jSPsiHelper;
    }

    @NotNull
    public QualifiedItemProcessor<ResolveResultSink> createQualifiedItemProcessor(@NotNull PsiElement place, @NotNull String name) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createQualifiedItemProcessor"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createQualifiedItemProcessor"));
        }
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = new QualifiedItemProcessor<ResolveResultSink>(new ResolveResultSink(place, name), place.getContainingFile());
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectSpecificHandlersFactory", "createQualifiedItemProcessor"));
        }
        return qualifiedItemProcessor;
    }
}

