/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSLookupPriority {
    NO_RELEVANT_SMARTNESS_PRIORITY(1, 0),
    RELEVANT_SMARTNESS_PRIORITY(1, 1),
    NO_RELEVANT_NO_SMARTNESS_PRIORITY(1, 2),
    NON_CONTEXT_KEYWORDS_PRIORITY(5, 0),
    RELEVANT_NO_SMARTNESS_PRIORITY(5, 1),
    TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES(5, 2),
    CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY(5, 3),
    KEYWORDS_PRIORITY(5, 4),
    MAX_PRIORITY(5, 5),
    NEIGHBOUR_REFERENCES_PRIORITY(5, 6),
    SMART_MATCHED_PARAMETER_NAME(8, 0),
    NESTING_LEVEL_REST(99, 94),
    NESTING_LEVEL_5(99, 95),
    NESTING_LEVEL_4(99, 96),
    NESTING_LEVEL_3(99, 97),
    NESTING_LEVEL_2(99, 98),
    NESTING_LEVEL_1(99, 99),
    LOCAL_SCOPE_MAX_PRIORITY(100, 0),
    SMART_KEYWORDS_PRIORITY(101, 0),
    SMART_PRIORITY(101, 0),
    MATCHED_PARAMETER_NAME(101, 0),
    MATCHED_TYPE_PRIORITY(102, 0);

    public static final Key<Integer> EXPLICIT_PROXIMITY_KEY;
    private final int myPriority;
    private final int myProximity;

    private JSLookupPriority(int priority, int proximity) {
        this.myPriority = priority;
        this.myProximity = proximity;
    }

    @NotNull
    public static JSLookupPriority getSameFileValue(boolean matchesReferencedParameterName, int nestingLevel) {
        if (matchesReferencedParameterName) {
            JSLookupPriority jSLookupPriority = MATCHED_PARAMETER_NAME;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getSameFileValue"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel < 0) {
            JSLookupPriority jSLookupPriority = NO_RELEVANT_NO_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getSameFileValue"));
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = JSLookupPriority.getNestingLevelPriority(nestingLevel);
        if (jSLookupPriority == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getSameFileValue"));
        }
        return jSLookupPriority;
    }

    @NotNull
    private static JSLookupPriority getNestingLevelPriority(int nestingLevel) {
        if (nestingLevel == 0) {
            JSLookupPriority jSLookupPriority = LOCAL_SCOPE_MAX_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 1) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_1;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 2) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_2;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 3) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_3;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 4) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_4;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 5) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_5;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = NESTING_LEVEL_REST;
        if (jSLookupPriority == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getNestingLevelPriority"));
        }
        return jSLookupPriority;
    }

    @NotNull
    public static JSLookupPriority getLookupPriority(@Nullable BaseJSSymbolProcessor.MatchType matchType, Boolean fromRelevantFileOrDirectory, Boolean hasSomeSmartnessAvailable) {
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            JSLookupPriority jSLookupPriority = LOCAL_SCOPE_MAX_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
            }
            return jSLookupPriority;
        }
        if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
            JSLookupPriority jSLookupPriority = RELEVANT_NO_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
            }
            return jSLookupPriority;
        }
        if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
            JSLookupPriority jSLookupPriority = NO_RELEVANT_NO_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
            }
            return jSLookupPriority;
        }
        if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
            JSLookupPriority jSLookupPriority = RELEVANT_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
            }
            return jSLookupPriority;
        }
        if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
            JSLookupPriority jSLookupPriority = NO_RELEVANT_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = NO_RELEVANT_NO_SMARTNESS_PRIORITY;
        if (jSLookupPriority == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupPriority", "getLookupPriority"));
        }
        return jSLookupPriority;
    }

    public static JSLookupPriority getSameTypeValue(boolean matchesReferencedParameterName, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (matchesReferencedParameterName && (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE)) {
            return MATCHED_PARAMETER_NAME;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            return JSLookupPriority.getNestingLevelPriority(nestingLevel);
        }
        return NO_RELEVANT_NO_SMARTNESS_PRIORITY;
    }

    public static JSLookupPriority getSmartVariantPriority(boolean matchesReferencedParameterName) {
        return matchesReferencedParameterName ? SMART_MATCHED_PARAMETER_NAME : MAX_PRIORITY;
    }

    public int getPriorityValue() {
        return this.myPriority;
    }

    public int getProximityValue() {
        return this.myProximity;
    }

    static {
        EXPLICIT_PROXIMITY_KEY = Key.create((String)"js.explicit.proximity.key");
    }
}

