/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final String COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION = "commonjs.complete.required.filename.with.extension";

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        String fileName = psiFile.getName();
        String extension = JSFileReference.findImplicitExtension(fileName);
        RegistryValue withExtValue = Registry.get((String)COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION);
        if (extension != null && !withExtValue.asBoolean()) {
            String nameWithoutExt = fileName.substring(0, fileName.length() - extension.length());
            return LookupElementBuilder.create((Object)psiFile, (String)nameWithoutExt).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
        }
        return null;
    }

    public static void setJSLookupPriority(@NotNull LookupItem<?> element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSCompletionUtil", "setJSLookupPriority"));
        }
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/completion/JSCompletionUtil", "setJSLookupPriority"));
        }
        element.setPriority((double)priority.getPriorityValue());
        element.putUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY, (Object)priority.getProximityValue());
    }

    @NotNull
    public static LookupElement withJSLookupPriority(@NotNull LookupElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSCompletionUtil", "withJSLookupPriority"));
        }
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/completion/JSCompletionUtil", "withJSLookupPriority"));
        }
        if (element instanceof LookupItem) {
            JSCompletionUtil.setJSLookupPriority((LookupItem)element, priority);
        } else {
            element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority.getPriorityValue());
            if (priority.getProximityValue() != 0) {
                element = PrioritizedLookupElement.withExplicitProximity((LookupElement)element, (int)priority.getProximityValue());
            }
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSCompletionUtil", "withJSLookupPriority"));
        }
        return lookupElement;
    }
}

