/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListFetchUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskTreeView;
import com.intellij.lang.javascript.buildTools.gulp.GulpTasksFetchSettingsDialog;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpService
extends JsbtService {
    private static final String GULPFILE_NAME_WITHOUT_EXT = "Gulpfile";
    private static final String[] FILENAMES_WITHOUT_EXT = new String[]{"gulpfile", "gulpfile.babel"};
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "es6", "js", "ts"};
    private static final NotNullLazyValue<GulpService> LAZY_INSTANCE = JsbtService.newLazyInstance(GulpService.class);

    @NotNull
    public static GulpService getInstance() {
        GulpService gulpService = (GulpService)LAZY_INSTANCE.getValue();
        if (gulpService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getInstance"));
        }
        return gulpService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Gulp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getName"));
        }
        return "Gulp";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Gulp16;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getFileManager"));
        }
        GulpfileManager gulpfileManager = GulpfileManager.getInstance(project);
        if (gulpfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getFileManager"));
        }
        return gulpfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createToolWindowManager"));
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "Gulp", JavaScriptLanguageIcons.BuildTools.Gulp_toolwindow, "reference.tool.window.js.build_tools.gulp", this);
        if (jsbtToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createToolWindowManager"));
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createTaskTreeView"));
        }
        GulpTaskTreeView gulpTaskTreeView = new GulpTaskTreeView(this, project, layoutPlace);
        if (gulpTaskTreeView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createTaskTreeView"));
        }
        return gulpTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfiles"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(JsbtUtil.detectAllBuildfiles(project, GULPFILE_NAME_WITHOUT_EXT, FILENAMES_WITHOUT_EXT, KNOWN_EXTENSIONS));
        List<VirtualFile> indexFiles = JsbtUtil.detectAllBuildfiles(project, "index.", new String[]{"index"}, KNOWN_EXTENSIONS);
        for (VirtualFile indexFile : indexFiles) {
            if (!GulpService.isIndexFile(indexFile)) continue;
            result.add(indexFile);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfiles"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfilesInContentRoots"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<VirtualFile> files = JsbtUtil.detectAllBuildfilesInContentRoots(project, webModulesOnly, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS, true);
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                VirtualFile indexFile = GulpService.findIndexFile(file);
                if (indexFile == null) continue;
                result.add(indexFile);
                continue;
            }
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectAllBuildfilesInContentRoots"));
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile findIndexFile(@NotNull VirtualFile gulpfileJsDir) {
        if (gulpfileJsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfileJsDir", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "findIndexFile"));
        }
        if (GulpService.isNameMatchedStrictly(gulpfileJsDir, "gulpfile")) {
            VirtualFile[] children;
            for (VirtualFile file : children = (VirtualFile[])ObjectUtils.notNull((Object)gulpfileJsDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                if (file.isDirectory() || !GulpService.isNameMatchedStrictly(file, "index")) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    public String getBuildfileCommonName() {
        return GULPFILE_NAME_WITHOUT_EXT;
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isBuildfile"));
        }
        if (JsbtUtil.isFilenameMatched(file.getNameSequence(), GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS)) {
            return true;
        }
        return GulpService.isIndexFile(file);
    }

    private static boolean isIndexFile(@NotNull VirtualFile indexFile) {
        if (indexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexFile", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isIndexFile"));
        }
        VirtualFile parent = indexFile.getParent();
        return parent != null && GulpService.isNameMatchedStrictly(parent, "gulpfile") && GulpService.isNameMatchedStrictly(indexFile, "index");
    }

    private static boolean isNameMatchedStrictly(@NotNull VirtualFile file, @NotNull String nameWithoutExtension) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isNameMatchedStrictly"));
        }
        if (nameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameWithoutExtension", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isNameMatchedStrictly"));
        }
        String ext = file.getExtension();
        return ext != null && ArrayUtil.contains((String)ext, (String[])KNOWN_EXTENSIONS) && nameWithoutExtension.equals(file.getNameWithoutExtension());
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createEmptyFileStructure"));
        }
        GulpfileStructure gulpfileStructure = new GulpfileStructure(buildfile);
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "createEmptyFileStructure"));
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public JsbtFileStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) throws JsbtTaskFetchException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        GulpfileStructure gulpfileStructure = GulpTaskListFetchUtil.listTasks(project, buildfile);
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "fetchBuildfileStructure"));
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GulpConfigurationType.getFactory();
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "getConfigurationFactory"));
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isConfigurationMatched"));
        }
        if (patternObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternObject", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "isConfigurationMatched"));
        }
        if (runConfiguration instanceof GulpRunConfiguration) {
            GulpRunSettings runSettings = ((GulpRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof GulpRunSettings) {
                GulpRunSettings patternRunSettings = (GulpRunSettings)patternObject;
                return JsbtUtil.equalsOrderless(patternRunSettings.getTasks(), runSettings.getTasks()) && patternRunSettings.getGulpfileSystemIndependentPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getTasks()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "setupRunConfiguration"));
        }
        if (taskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "setupRunConfiguration"));
        }
        GulpfileStructure structure = (GulpfileStructure)taskSet.getStructure();
        GulpRunConfiguration gulpRunConfiguration = (GulpRunConfiguration)runConfiguration;
        GulpRunSettings merged = new GulpRunSettings.Builder(gulpRunConfiguration.getRunSettings()).setGulpfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GulpRunConfigurationProducer.setupConfigurationFromSettings(gulpRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "showTaskListingSettingsDialog"));
        }
        return new GulpTasksFetchSettingsDialog(project, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpService", "detectFirstBuildfileInContentRoots"));
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }
}

