/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpReferenceContributor
extends PsiReferenceContributor {
    private static final ElementPattern<JSLiteralExpression> DEPENDENCY_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            JSLiteralExpression literal;
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral()) {
                JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)literal);
                return jsFile != null && GulpfilePsiStructure.isDependency(literal);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(DEPENDENCY_PLACE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2", "getReferencesByElement"));
                }
                JSLiteralExpression literal = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class);
                if (literal != null && literal.isQuotedLiteral()) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new GulpTaskReference(literal)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    @Nullable
    private static JSFile getJSFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return (JSFile)ObjectUtils.tryCast((Object)psiFile.getOriginalFile(), JSFile.class);
        }
        return null;
    }

    private static class GulpTaskReference
    implements PsiReference {
        private final JSLiteralExpression myDependency;

        public GulpTaskReference(@NotNull JSLiteralExpression dependency) {
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference", "<init>"));
            }
            this.myDependency = dependency;
        }

        public PsiElement getElement() {
            return this.myDependency;
        }

        public TextRange getRangeInElement() {
            int length = this.myDependency.getTextLength();
            if (length < 2) {
                return new TextRange(0, length);
            }
            return new TextRange(1, length - 1);
        }

        @Nullable
        public PsiElement resolve() {
            JSExpression[] arguments;
            String taskName;
            GulpfilePsiStructure structure;
            JSCallExpression callExpr;
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile != null && (callExpr = (structure = GulpfilePsiStructure.get(jsFile)).getPsiByName(taskName = StringUtil.unquoteString((String)this.myDependency.getText()))) != null && (arguments = callExpr.getArguments()).length > 0) {
                return arguments[0];
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            TextRange range = this.getRangeInElement();
            String string = range.substring(this.myDependency.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            ElementManipulator elementManipulator = ElementManipulators.getManipulator((PsiElement)this.myDependency);
            if (elementManipulator != null) {
                return elementManipulator.handleContentChange((PsiElement)this.myDependency, this.getRangeInElement(), newElementName);
            }
            throw new IncorrectOperationException("Cannot handleElementRename for " + this.myDependency.getClass());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            JSLiteralExpression literal;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference", "bindToElement"));
            }
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral()) {
                return this.handleElementRename(StringUtil.unquoteString((String)literal.getText()));
            }
            throw new IncorrectOperationException("Cannot bindToElement(class: " + element.getClass() + ")");
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myDependency.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            GulpfilePsiStructure structure = GulpfilePsiStructure.get(jsFile);
            Object[] objectArray = ArrayUtil.toStringArray(structure.getTasks());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

