/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunProfileState;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.InetSocketAddress;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration {
    private static final Logger LOG = Logger.getInstance(GruntRunConfiguration.class);
    private GruntRunSettings myRunSettings;

    public GruntRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "<init>"));
        }
        super(project, factory, name);
    }

    public void initializeFields() {
        Iterator<VirtualFile> configuredFileIterator;
        VirtualFile gruntfile;
        GruntRunSettings runSettings = this.getRunSettings();
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getGruntfilePath()) && (gruntfile = (configuredFileIterator = GruntfileManager.getInstance(this.getProject()).getBuildfiles().iterator()).hasNext() ? configuredFileIterator.next() : GruntService.getInstance().detectFirstBuildfileInContentRoots(this.getProject(), false)) != null) {
            this.myRunSettings = GruntRunSettings.builder(runSettings).setGruntfilePath(gruntfile.getPath()).build();
        }
    }

    @NotNull
    public GruntRunSettings getRunSettings() {
        if (this.myRunSettings == null) {
            this.myRunSettings = new GruntRunSettings.Builder().build();
        }
        GruntRunSettings gruntRunSettings = this.myRunSettings;
        if (gruntRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getRunSettings"));
        }
        return gruntRunSettings;
    }

    public void setRunSettings(@NotNull GruntRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "setRunSettings"));
        }
        this.myRunSettings = runSettings;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunSettings = GruntRunSettings.readFromXml(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        GruntRunSettings runSettings = this.myRunSettings;
        if (runSettings != null) {
            runSettings.writeToXml(element);
        }
    }

    @Nullable
    private static GruntRunConfiguration getTemplateRunConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getTemplateRunConfiguration"));
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings templateSettings = runManager.getConfigurationTemplate(GruntConfigurationType.getFactory());
        RunConfiguration rc = templateSettings.getConfiguration();
        if (rc instanceof GruntRunConfiguration) {
            return (GruntRunConfiguration)rc;
        }
        LOG.warn("No Grunt.js template run configuration found: " + rc);
        return null;
    }

    @NotNull
    public static GruntRunSettings getTemplateRunSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getTemplateRunSettings"));
        }
        GruntRunConfiguration rc = GruntRunConfiguration.getTemplateRunConfiguration(project);
        if (rc != null) {
            GruntRunSettings gruntRunSettings = rc.getRunSettings();
            if (gruntRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getTemplateRunSettings"));
            }
            return gruntRunSettings;
        }
        GruntRunSettings gruntRunSettings = new GruntRunSettings.Builder().build();
        if (gruntRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getTemplateRunSettings"));
        }
        return gruntRunSettings;
    }

    public static void setTemplateRunSettings(@NotNull Project project, @NotNull GruntRunSettings runSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "setTemplateRunSettings"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "setTemplateRunSettings"));
        }
        GruntRunConfiguration rc = GruntRunConfiguration.getTemplateRunConfiguration(project);
        if (rc != null) {
            rc.setRunSettings(runSettings);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        GruntRunConfiguration.checkRunSettings(this.getProject(), this.myRunSettings);
    }

    public static void checkRunSettings(@NotNull Project project, @NotNull GruntRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "checkRunSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "checkRunSettings"));
        }
        GruntNonSharedSettings nonSharedSettings = GruntRunConfiguration.getNonSharedSettings(project, settings);
        GruntUtil.checkConfiguration(project, nonSharedSettings, settings);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        GruntRunConfigurationEditor gruntRunConfigurationEditor = new GruntRunConfigurationEditor(this.getProject());
        if (gruntRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getConfigurationEditor"));
        }
        return gruntRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getState"));
        }
        return new GruntRunProfileState(environment, this.getRunSettings(), GruntRunConfiguration.getNonSharedSettings(this.getProject(), this.myRunSettings));
    }

    @NotNull
    private static GruntNonSharedSettings getNonSharedSettings(@NotNull Project project, @NotNull GruntRunSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getNonSharedSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getNonSharedSettings"));
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        GruntNonSharedSettings gruntNonSharedSettings = GruntNonSharedSettingsManager.getInstance(project).get(interpreter, settings.getGruntfile());
        if (gruntNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration", "getNonSharedSettings"));
        }
        return gruntNonSharedSettings;
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }
}

