/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntNonSharedSettingsManager {
    private static final String STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH = "js.buildTools.grunt.grunt-cli.package";
    private final Project myProject;
    private volatile GruntNonSharedSettings myNonSharedSettings;

    public GruntNonSharedSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "<init>"));
        }
        this.myNonSharedSettings = new GruntNonSharedSettings("");
        this.myProject = project;
    }

    @NotNull
    public GruntNonSharedSettings get(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        GruntNonSharedSettings settings = this.myNonSharedSettings;
        if (!settings.getGruntCliPackageDirPath().isEmpty()) {
            GruntNonSharedSettings gruntNonSharedSettings = settings;
            if (gruntNonSharedSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "get"));
            }
            return gruntNonSharedSettings;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String gruntCliPackageDirPath = propertiesComponent.getValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH);
        if (StringUtil.isEmpty((String)gruntCliPackageDirPath)) {
            gruntCliPackageDirPath = StringUtil.notNullize((String)this.detectGruntCliPackageDirPath(interpreter, contextGruntfile));
        }
        settings = new GruntNonSharedSettings(gruntCliPackageDirPath);
        this.set(settings);
        GruntNonSharedSettings gruntNonSharedSettings = settings;
        if (gruntNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "get"));
        }
        return gruntNonSharedSettings;
    }

    @Nullable
    private String detectGruntCliPackageDirPath(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        List<String> paths = this.detectAllGruntCliPackageDirPaths(interpreter, contextGruntfile);
        return (String)ContainerUtil.getFirstItem(paths);
    }

    private void set(@NotNull GruntNonSharedSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "set"));
        }
        this.myNonSharedSettings = settings;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH, settings.getGruntCliPackageDirSystemIndependentPath());
    }

    public void set(@NotNull String gruntCliPackageDirPath) {
        if (gruntCliPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDirPath", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "set"));
        }
        this.set(new GruntNonSharedSettings(gruntCliPackageDirPath));
    }

    @NotNull
    public List<String> detectAllGruntCliPackageDirPaths(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        ArrayList paths = ContainerUtil.newArrayList();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        NodeSettings nodeSettings = null;
        if (localInterpreter != null) {
            nodeSettings = new NodeSettings(localInterpreter.getInterpreterSystemDependentPath());
        }
        VirtualFile requester = contextGruntfile != null ? contextGruntfile : this.myProject.getBaseDir();
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName(modules, "grunt-cli", requester, nodeSettings, true);
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            paths.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "detectAllGruntCliPackageDirPaths"));
        }
        return arrayList;
    }

    @NotNull
    public static GruntNonSharedSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "getInstance"));
        }
        GruntNonSharedSettingsManager gruntNonSharedSettingsManager = (GruntNonSharedSettingsManager)ServiceManager.getService((Project)project, GruntNonSharedSettingsManager.class);
        if (gruntNonSharedSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "getInstance"));
        }
        return gruntNonSharedSettingsManager;
    }
}

