/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.CommandLineUtil;
import com.intellij.webcore.util.JsonUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskStructureUtil {
    private static final Logger LOG = Logger.getInstance(GruntTaskStructureUtil.class);
    private static final String GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME = "_intellij_grunt_tasks_fetcher";
    private static final String NAME_PROP = "name";
    private static final String INFO_PROP = "info";
    private static final String FILE_PATH_PROP = "filePath";
    private static final String MULTI_PROP = "multi";
    private static final String DEPENDENCIES_PROP = "dependencies";
    private static final String TARGETS_PROP = "targets";

    private GruntTaskStructureUtil() {
    }

    @NotNull
    public static GruntfileStructure fetchStructure(@Nullable NodeJsInterpreter interpreter, @NotNull String nodeOptions, @NotNull String gruntCliPackageDir, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        List<JsbtInvalidSetting> invalidSettings = GruntTaskStructureUtil.checkSettings(interpreter, gruntCliPackageDir);
        if (!invalidSettings.isEmpty()) {
            throw JsbtTaskFetchException.newInvalidSettings(gruntfile, invalidSettings);
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new IllegalStateException("Local Node.js interpreter is required");
        }
        try {
            gruntfileStructure = GruntTaskStructureUtil.fetchStructure(localInterpreter, nodeOptions, gruntCliPackageDir, gruntfile, envData, false);
        }
        catch (JsbtTaskFetchException e) {
            LOG.info("Failed to fetch tasks: " + e.getDescription() + ". Re-fetching in verbose mode to present a detailed error");
            GruntfileStructure gruntfileStructure2 = GruntTaskStructureUtil.fetchStructure(localInterpreter, nodeOptions, gruntCliPackageDir, gruntfile, envData, true);
            if (gruntfileStructure2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
            }
            return gruntfileStructure2;
        }
        if (gruntfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        return gruntfileStructure;
    }

    private static GruntfileStructure fetchStructure(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String nodeOptions, @NotNull String gruntCliPackageDir, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) throws JsbtTaskFetchException {
        CapturingProcessHandler processHandler;
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "fetchStructure"));
        }
        GeneralCommandLine commandLine = GruntTaskStructureUtil.createCommandLine(interpreter, nodeOptions, gruntCliPackageDir, gruntfile, envData, verboseMode);
        LOG.info("Fetching grunt tasks: " + commandLine.getCommandLineString());
        long startTimeMillis = System.currentTimeMillis();
        try {
            processHandler = new CapturingProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot fetch grunt tasks: cannot run " + commandLine.getCommandLineString(), (Throwable)e);
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "cannot execute command", commandLine, e, null, null);
        }
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput.getExitCode() != 0) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "process finished with exit code " + processOutput.getExitCode() + " (a non-zero exit code means an error)", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        GruntfileStructure structure = GruntTaskStructureUtil.parseStructure(gruntfile, processOutput.getStdout());
        if (structure == null) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "failed to parse tasks from json", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        LOG.info(String.format("%s: %d alias tasks and %d core tasks listed in %d ms", gruntfile.getPath(), structure.getAliasTasks().size(), structure.getCoreTasks().size(), System.currentTimeMillis() - startTimeMillis));
        return structure;
    }

    @NotNull
    private static List<JsbtInvalidSetting> checkSettings(@Nullable NodeJsInterpreter interpreter, @NotNull String gruntCliPackageDir) {
        JsbtInvalidSetting gruntCliPackageError;
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "checkSettings"));
        }
        ArrayList errorInfos = ContainerUtil.newArrayListWithCapacity((int)2);
        String interpreterErrorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (interpreterErrorMessage != null) {
            errorInfos.add(new JsbtInvalidSetting("Node interpreter", null, interpreterErrorMessage));
        }
        if ((gruntCliPackageError = JsbtUtil.validatePackageDir(gruntCliPackageDir, "Grunt-cli package", "grunt-cli")) != null) {
            errorInfos.add(gruntCliPackageError);
        }
        ArrayList arrayList = errorInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "checkSettings"));
        }
        return arrayList;
    }

    @NotNull
    private static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile gruntfile, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "newFetchFail"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "newFetchFail"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "newFetchFail"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newFetchFail(gruntfile, GruntService.getInstance(), "grunt", JavaScriptLanguageIcons.BuildTools.Grunt.Grunt, message, commandLine, "grunt <list tasks>", executionException, processHandler, processOutput);
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "newFetchFail"));
        }
        return jsbtTaskFetchException;
    }

    @Nullable
    private static GruntfileStructure parseStructure(@NotNull VirtualFile gruntfile, @NotNull String stdout) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructure"));
        }
        if (stdout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructure"));
        }
        Iterable lines = Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)stdout);
        for (String line : lines) {
            if ((line.startsWith("Reading ") || line.startsWith("Loading ")) && line.endsWith("ERROR")) {
                return null;
            }
            GruntfileStructure structure = GruntTaskStructureUtil.parseStructureFromLine(gruntfile, line);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static GruntfileStructure parseStructureFromLine(@NotNull VirtualFile gruntfile, @NotNull String line) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructureFromLine"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructureFromLine"));
        }
        if (!line.startsWith("{")) {
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new StringReader(line));
            jsonReader.setLenient(false);
            JsonElement rootElement = parser.parse(jsonReader);
            if (rootElement.isJsonObject()) {
                GruntfileStructure gruntfileStructure = GruntTaskStructureUtil.parseStructureFromElement(gruntfile, rootElement.getAsJsonObject());
                return gruntfileStructure;
            }
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        catch (Exception e) {
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close jsonReader", (Throwable)e);
                }
            }
        }
    }

    private static GruntfileStructure parseStructureFromElement(@NotNull VirtualFile gruntfile, @NotNull JsonObject rootObject) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructureFromElement"));
        }
        if (rootObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootObject", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "parseStructureFromElement"));
        }
        JsonArray aliasTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"aliasTasks");
        if (aliasTaskArray == null) {
            return null;
        }
        JsonArray coreTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"coreTasks");
        if (coreTaskArray == null) {
            return null;
        }
        GruntfileStructure structure = new GruntfileStructure(gruntfile);
        ArrayList aliasTasks = ContainerUtil.newArrayList();
        for (JsonElement aliasElement : aliasTaskArray) {
            if (!aliasElement.isJsonObject()) continue;
            JsonObject aliasObject = aliasElement.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)NAME_PROP);
            String info = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)INFO_PROP);
            String filePath = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)FILE_PATH_PROP);
            boolean multi = JsonUtil.getChildAsBoolean((JsonObject)aliasObject, (String)MULTI_PROP, (boolean)false);
            List<String> dependencies = JsonUtil.getChildAsStringList((JsonObject)aliasObject, (String)DEPENDENCIES_PROP);
            if (dependencies == null) {
                dependencies = Collections.emptyList();
            }
            if (name == null) continue;
            aliasTasks.add(new GruntAliasTask(structure, name, info, filePath, multi, dependencies));
        }
        ArrayList coreTasks = ContainerUtil.newArrayList();
        for (JsonElement coreTaskElement : coreTaskArray) {
            if (!coreTaskElement.isJsonObject()) continue;
            JsonObject coreTaskObject = coreTaskElement.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)NAME_PROP);
            String info = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)INFO_PROP);
            String filePath = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)FILE_PATH_PROP);
            boolean multi = JsonUtil.getChildAsBoolean((JsonObject)coreTaskObject, (String)MULTI_PROP, (boolean)false);
            List<String> targets = JsonUtil.getChildAsStringList((JsonObject)coreTaskObject, (String)TARGETS_PROP);
            if (targets == null) {
                targets = Collections.emptyList();
            }
            if (name == null) continue;
            coreTasks.add(new GruntCoreTask(structure, name, info, filePath, multi, targets));
        }
        structure.setTasks(aliasTasks, coreTasks);
        return structure;
    }

    @NotNull
    private static File findGruntJsDir() {
        String jarPath = PathUtil.getJarPathForClass(GruntTaskStructureUtil.class);
        if (!jarPath.endsWith(".jar")) {
            String packageName = GruntTaskStructureUtil.class.getPackage().getName() + ".grunt_js";
            File file = new File(jarPath, packageName.replace('.', File.separatorChar));
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "findGruntJsDir"));
            }
            return file;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file not found");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        File file = new File(pluginBaseDir, "grunt_js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "findGruntJsDir"));
        }
        return file;
    }

    @NotNull
    public static File getTasksDir() {
        File jsDir = GruntTaskStructureUtil.findGruntJsDir();
        File file = new File(jsDir, "tasks");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "getTasksDir"));
        }
        return file;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String nodeOptions, @NotNull String gruntCliPackageDir, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfile", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        envData.configureCommandLine(commandLine, true);
        File gruntfileDir = VfsUtilCore.virtualToIoFile((VirtualFile)gruntfile).getParentFile();
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)gruntfileDir, (boolean)true);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        nodeOptions = nodeOptions.trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(gruntCliPackageDir));
        commandLine.addParameter("--no-color");
        if (verboseMode) {
            commandLine.addParameter("--verbose");
        }
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)gruntfile.getPath()));
        commandLine.addParameter("--tasks");
        File tasksDir = GruntTaskStructureUtil.getTasksDir();
        commandLine.addParameter(tasksDir.getAbsolutePath());
        commandLine.addParameter(GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public static String getGruntCliMainFilePath(@NotNull String gruntCliPackageDirPath) {
        if (gruntCliPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDirPath", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "getGruntCliMainFilePath"));
        }
        gruntCliPackageDirPath = FileUtil.toSystemDependentName((String)gruntCliPackageDirPath);
        String string = StringUtil.trimEnd((String)gruntCliPackageDirPath, (String)File.separator) + File.separator + "bin" + File.separator + "grunt";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil", "getGruntCliMainFilePath"));
        }
        return string;
    }
}

