/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskListingSettingsDialog
extends DialogWrapper {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final TextFieldWithHistoryWithBrowseButton myGruntCliPackageTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected GruntTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Grunt Settings");
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GruntRunConfigurationEditor.createNodeOptionsEditor();
        this.myGruntCliPackageTextFieldWithBrowseButton = GruntRunConfigurationEditor.createGruntPackageDirTextFieldWithBrowseButton(project, this.myNodeInterpreterField, contextGruntfile);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"grunt.rc.gruntCliPackage.label", (Object[])new Object[0]), (JComponent)this.myGruntCliPackageTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"grunt.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreter interpreter = templateRunSettings.getInterpreterRef().resolve(project);
        this.myNodeInterpreterField.setInterpreter(interpreter);
        GruntNonSharedSettings settings = GruntNonSharedSettingsManager.getInstance(project).get(interpreter, contextGruntfile);
        this.myGruntCliPackageTextFieldWithBrowseButton.setTextAndAddToHistory(settings.getGruntCliPackageDirPath());
        this.myNodeOptionsEditor.setText(templateRunSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(templateRunSettings.getEnvData());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGruntCliPackageTextFieldWithBrowseButton);
        int prefWidth = Math.max(this.myNodeInterpreterField.getPreferredSize().width, this.myGruntCliPackageTextFieldWithBrowseButton.getPreferredSize().width);
        int minWidth = JBUI.scale((int)300);
        if (prefWidth < minWidth) {
            SwingHelper.setPreferredWidth((Component)((Object)this.myNodeInterpreterField), (int)minWidth);
        }
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNodeInterpreterField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String interpreterError = NodeJsLocalInterpreter.getErrorMessage(this.myNodeInterpreterField.getInterpreter());
        if (interpreterError != null) {
            return new ValidationInfo(interpreterError, (JComponent)((Object)this.myNodeInterpreterField));
        }
        String gruntCliPackageError = GruntTaskListingSettingsDialog.validateGruntCliPackage(this.myGruntCliPackageTextFieldWithBrowseButton.getText());
        if (gruntCliPackageError != null) {
            return new ValidationInfo(gruntCliPackageError, (JComponent)((TextFieldWithHistory)this.myGruntCliPackageTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        }
        return null;
    }

    @Nullable
    private static String validateGruntCliPackage(@NotNull String gruntCliPackageDir) {
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "validateGruntCliPackage"));
        }
        if (StringUtil.isEmptyOrSpaces((String)gruntCliPackageDir)) {
            return "Please specify grunt-cli package";
        }
        File file = new File(gruntCliPackageDir);
        if (!file.isAbsolute() || !file.isDirectory()) {
            return "Please specify grunt-cli package correctly";
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        GruntNonSharedSettingsManager.getInstance(this.myProject).set(this.myGruntCliPackageTextFieldWithBrowseButton.getText());
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(this.myProject);
        GruntRunSettings.Builder builder = GruntRunSettings.builder(templateRunSettings);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GruntRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }
}

