/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtPersistentPath;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayout;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsbtTreeLayoutManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JsbtTreeLayoutManager
implements PersistentStateComponent<Element> {
    private static final String LAYOUTS = "layouts";
    private static final String LAYOUT = "layout";
    private static final String PLACE = "place";
    private static final String SCROLL_VIEW_POSITION = "scroll-view-position";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String SELECTED_PATHS = "selected-paths";
    private static final String PATH = "path";
    private static final String ID = "id";
    private final Map<String, JsbtTreeLayout> myMap = ContainerUtil.newLinkedHashMap();

    @Nullable
    public JsbtTreeLayout getLayout(@NotNull String layoutPlace) {
        if (layoutPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutPlace", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "getLayout"));
        }
        return this.myMap.get(layoutPlace);
    }

    public void add(@NotNull JsbtTreeLayout layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LAYOUT, "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "add"));
        }
        this.myMap.put(layout.getPlace(), layout);
    }

    @Nullable
    public Element getState() {
        if (this.myMap.isEmpty()) {
            return null;
        }
        Element element = new Element(LAYOUTS);
        for (JsbtTreeLayout layout : this.myMap.values()) {
            element.addContent(JsbtTreeLayoutManager.toXml(layout));
        }
        return element;
    }

    @NotNull
    private static Element toXml(@NotNull JsbtTreeLayout layout) {
        List<JsbtPersistentPath> selectedPaths;
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LAYOUT, "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "toXml"));
        }
        Element element = new Element(LAYOUT);
        element.setAttribute(PLACE, layout.getPlace());
        Point position = layout.getScrollPaneViewPosition();
        if (position != null) {
            Element scrollPaneViewPositionElement = new Element(SCROLL_VIEW_POSITION);
            scrollPaneViewPositionElement.setAttribute(X, String.valueOf(position.x));
            scrollPaneViewPositionElement.setAttribute(Y, String.valueOf(position.y));
            element.addContent(scrollPaneViewPositionElement);
        }
        if (!(selectedPaths = layout.getSelectedPaths()).isEmpty()) {
            Element selectedPathsElement = new Element(SELECTED_PATHS);
            for (JsbtPersistentPath path : selectedPaths) {
                Element selectedPathElement = new Element(PATH);
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)selectedPathElement, (String)ID, path.getIds());
                selectedPathsElement.addContent(selectedPathElement);
            }
            element.addContent(selectedPathsElement);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "toXml"));
        }
        return element2;
    }

    public void loadState(Element state) {
        this.myMap.clear();
        if (state != null) {
            List layoutElements = state.getChildren(LAYOUT);
            for (Element child : layoutElements) {
                JsbtTreeLayout layout = JsbtTreeLayoutManager.fromXml(child);
                if (layout == null) continue;
                this.add(layout);
            }
        }
    }

    @Nullable
    private static JsbtTreeLayout fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "fromXml"));
        }
        String place = element.getAttributeValue(PLACE);
        if (StringUtil.isEmptyOrSpaces((String)place)) {
            return null;
        }
        Point position = JsbtTreeLayoutManager.toPoint(element.getChild(SCROLL_VIEW_POSITION));
        List<JsbtPersistentPath> selectedPaths = JsbtTreeLayoutManager.parseSelectedPaths(element.getChild(SELECTED_PATHS));
        return new JsbtTreeLayout(place, position, selectedPaths);
    }

    @Nullable
    private static Point toPoint(@Nullable Element scrollPaneViewPositionElement) {
        if (scrollPaneViewPositionElement != null) {
            int x = StringUtil.parseInt((String)scrollPaneViewPositionElement.getAttributeValue(X), (int)-1);
            int y = StringUtil.parseInt((String)scrollPaneViewPositionElement.getAttributeValue(Y), (int)-1);
            if (x >= 0 && y >= 0) {
                return new Point(x, y);
            }
        }
        return null;
    }

    @NotNull
    private static List<JsbtPersistentPath> parseSelectedPaths(@Nullable Element pathsElement) {
        if (pathsElement == null) {
            List<JsbtPersistentPath> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "parseSelectedPaths"));
            }
            return list;
        }
        List pathElements = pathsElement.getChildren(PATH);
        ArrayList paths = ContainerUtil.newArrayList();
        for (Element pathElement : pathElements) {
            List ids = JDOMExternalizerUtil.getChildrenValueAttributes((Element)pathElement, (String)ID);
            paths.add(new JsbtPersistentPath(ids));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "parseSelectedPaths"));
        }
        return arrayList;
    }

    @NotNull
    public static JsbtTreeLayoutManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "getInstance"));
        }
        JsbtTreeLayoutManager jsbtTreeLayoutManager = (JsbtTreeLayoutManager)ServiceManager.getService((Project)project, JsbtTreeLayoutManager.class);
        if (jsbtTreeLayoutManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTreeLayoutManager", "getInstance"));
        }
        return jsbtTreeLayoutManager;
    }
}

