/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtToolWindowPanel
extends SimpleToolWindowPanel {
    private final Project myProject;
    private final JsbtTaskTreeView myTaskTreeView;
    private final String myHelpId;

    public JsbtToolWindowPanel(@NotNull Project project, @NotNull JsbtTaskTreeView taskTreeView, @NotNull String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowPanel", "<init>"));
        }
        if (taskTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskTreeView", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowPanel", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowPanel", "<init>"));
        }
        super(true, true);
        this.myProject = project;
        this.myTaskTreeView = taskTreeView;
        this.myHelpId = helpId;
        Disposer.register((Disposable)project, (Disposable)this.myTaskTreeView);
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTaskTreeView.getComponent(), (int)20, (int)30));
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowPanel", "getProject"));
        }
        return project;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTaskTreeView.getComponent();
    }
}

