/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.execution.ExecutionException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinkListeningExecutionException
extends ExecutionException
implements HyperlinkListener {
    @Nullable
    private final Runnable myHyperlinkActivatedRunnable;

    public HyperlinkListeningExecutionException(@NotNull String message, @Nullable Runnable onHyperlinkActivated) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/buildTools/HyperlinkListeningExecutionException", "<init>"));
        }
        super(message);
        this.myHyperlinkActivatedRunnable = onHyperlinkActivated;
    }

    @Override
    public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/HyperlinkListeningExecutionException", "hyperlinkUpdate"));
        }
        if (this.myHyperlinkActivatedRunnable != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.myHyperlinkActivatedRunnable.run();
        }
    }
}

