/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerValidationInfo {
    public static final String LINK_TEMPLATE = "{{LINK}}";
    private static final Logger LOG = Logger.getInstance(BowerValidationInfo.class);
    private final Component myComponent;
    private final String myErrorHtmlDescription;
    private final String myLinkText;

    public BowerValidationInfo(@Nullable Component component, @NotNull String errorHtmlDescriptionTemplate, @NotNull String linkText) {
        if (errorHtmlDescriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHtmlDescriptionTemplate", "com/intellij/lang/javascript/bower/BowerValidationInfo", "<init>"));
        }
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/lang/javascript/bower/BowerValidationInfo", "<init>"));
        }
        this.myComponent = component;
        if (!errorHtmlDescriptionTemplate.contains(LINK_TEMPLATE)) {
            LOG.warn("Cannot find {{LINK}} in " + errorHtmlDescriptionTemplate);
        }
        String linkHtml = "<a href='" + linkText + "'>" + linkText + "</a>";
        this.myErrorHtmlDescription = errorHtmlDescriptionTemplate.replace(LINK_TEMPLATE, linkHtml);
        this.myLinkText = linkText;
    }

    @Nullable
    public Component getComponent() {
        return this.myComponent;
    }

    @NotNull
    public String getErrorHtmlDescription() {
        String string = this.myErrorHtmlDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerValidationInfo", "getErrorHtmlDescription"));
        }
        return string;
    }

    @Nullable
    public String getLinkText() {
        return this.myLinkText;
    }
}

