/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerPackageUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.cache.PrevRequestSkippingCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageInfoManager {
    private final BowerSettings mySettings;
    private PrevRequestSkippingCache<String, BowerPackageInfo> myCache;

    public BowerPackageInfoManager(@NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerPackageInfoManager", "<init>"));
        }
        this.mySettings = settings;
        this.myCache = new PrevRequestSkippingCache<String, BowerPackageInfo>(new PrevRequestSkippingCache.Fetcher<String, BowerPackageInfo>(){

            @Override
            @Nullable
            public BowerPackageInfo fetch(@NotNull String packageName) throws Exception {
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerPackageInfoManager$1", "fetch"));
                }
                return BowerPackageUtil.loadPackageInfo(BowerPackageInfoManager.this.mySettings, packageName);
            }
        });
    }

    public void fetchPackageInfo(final @NotNull PackageInfoConsumer packageInfoConsumer) {
        if (packageInfoConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageInfoConsumer", "com/intellij/lang/javascript/bower/BowerPackageInfoManager", "fetchPackageInfo"));
        }
        String packageName = packageInfoConsumer.myPackageName;
        boolean canBeSkipped = packageInfoConsumer.myCanBeSkipped;
        PrevRequestSkippingCache.FetchCallback<String, BowerPackageInfo> callback = new PrevRequestSkippingCache.FetchCallback<String, BowerPackageInfo>(packageName, canBeSkipped){

            @Override
            public void onSuccess(@Nullable BowerPackageInfo packageInfo) {
                packageInfoConsumer.onPackageInfo(packageInfo);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/bower/BowerPackageInfoManager$2", "onException"));
                }
                packageInfoConsumer.onException(e);
            }
        };
        this.myCache.fetch(callback);
    }

    public static abstract class PackageInfoConsumer {
        private final String myPackageName;
        private final boolean myCanBeSkipped;

        public PackageInfoConsumer(@NotNull String packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerPackageInfoManager$PackageInfoConsumer", "<init>"));
            }
            this(packageName, true);
        }

        public PackageInfoConsumer(@NotNull String packageName, boolean canBeSkipped) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerPackageInfoManager$PackageInfoConsumer", "<init>"));
            }
            this.myPackageName = packageName;
            this.myCanBeSkipped = canBeSkipped;
        }

        public abstract void onPackageInfo(@Nullable BowerPackageInfo var1);

        public abstract void onException(@NotNull Exception var1);
    }
}

