/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.lang.javascript.bower.BowerView;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerConfigurable
implements Configurable,
Configurable.NoScroll {
    private final Project myProject;
    private BowerView myView;

    public BowerConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerConfigurable", "<init>"));
        }
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.bower.configurable.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "Settings.JavaScript.Bower";
    }

    @Nullable
    public JComponent createComponent() {
        BowerView view = this.getView();
        return view.getComponent();
    }

    public boolean isModified() {
        BowerSettings storedSettings;
        BowerView view = this.getView();
        BowerSettings viewSettings = view.getSettings();
        return !viewSettings.equals(storedSettings = BowerSettingsManager.getInstance(this.myProject).getSettings());
    }

    public void apply() throws ConfigurationException {
        BowerView view = this.getView();
        BowerSettings settings = view.getSettings();
        BowerSettingsManager.getInstance(this.myProject).setSettings(settings);
    }

    public void reset() {
        BowerSettings settings = BowerSettingsManager.getInstance(this.myProject).getSettings();
        BowerView view = this.getView();
        view.setSettings(settings);
    }

    public void disposeUIResources() {
    }

    private BowerView getView() {
        if (this.myView == null) {
            this.myView = new BowerView(this.myProject);
        }
        return this.myView;
    }
}

