/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "includeSelfInGotoImplementation"));
        }
        return !(element instanceof JSFunction ? (parent = JSResolveUtil.findParent(element)) instanceof JSClass && ((JSClass)parent).isInterface() : element instanceof JSClass);
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getElementByReference"));
        }
        if (ref instanceof JSReferenceExpression) {
            PsiElement resolve;
            JSExpression value;
            PsiElement element;
            ResolveResult[] results = ((JSReferenceExpression)ref).multiResolve(false);
            if (results.length > 1) {
                return JSTargetElementEvaluator.getFirstDefinitionIfDuplicates(results);
            }
            if (results.length == 1 && (element = results[0].getElement()) instanceof ES6Property && ((ES6Property)element).isShorthanded() && (value = ((ES6Property)element).getValue()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)value).resolve()) != null) {
                return resolve;
            }
        } else {
            if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(ref)) {
                return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)ref);
            }
            if (ref instanceof PsiMultiReference) {
                for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                    if (!JSTargetElementEvaluator.isLastTypeScriptModuleRef(reference)) continue;
                    return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)reference);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getFirstDefinitionIfDuplicates(ResolveResult[] results) {
        boolean first = true;
        JSQualifiedName namespace = null;
        PsiFile file = null;
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!(element instanceof JSDefinitionExpression)) {
                return null;
            }
            if (((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer() != null) {
                return null;
            }
            if (first) {
                first = false;
                namespace = ((JSDefinitionExpression)element).getNamespace();
                file = element.getContainingFile();
                continue;
            }
            if (Comparing.equal(namespace, (Object)((JSDefinitionExpression)element).getNamespace()) && Comparing.equal((Object)file, (Object)element.getContainingFile())) continue;
            return null;
        }
        return results[0].getElement();
    }

    private static boolean isLastTypeScriptModuleRef(@NotNull PsiReference ref) {
        TypeScriptFileModuleReference moduleReference;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/JSTargetElementEvaluator", "isLastTypeScriptModuleRef"));
        }
        return ref instanceof TypeScriptFileModuleReference && (moduleReference = (TypeScriptFileModuleReference)ref).isLast();
    }

    @Nullable
    private static PsiElement getForTypeScriptModuleRef(@NotNull TypeScriptFileModuleReference reference) {
        Collection elements;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getForTypeScriptModuleRef"));
        }
        PsiElement element = reference.getElement();
        if (element instanceof ES6FromClause && (elements = ((ES6FromClause)element).resolveReferencedElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        ASTNode node;
        Collection implicitElements;
        JSImplicitElement implicitElement;
        JSElementIndexingData indexingData;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getNamedElement"));
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof JSNamedElement) && !(element instanceof JSImplicitElementProvider) && parent instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)parent).getIndexingData()) != null && (implicitElement = (JSImplicitElement)ContainerUtil.getFirstItem((Collection)(implicitElements = indexingData.getImplicitElements()))) != null) {
            return implicitElement;
        }
        if (parent instanceof ES6ExportDefaultAssignment && ((node = element.getNode()).getElementType() == JSTokenTypes.EXPORT_KEYWORD || node.getElementType() == JSTokenTypes.DEFAULT_KEYWORD)) {
            return parent;
        }
        if (parent instanceof JSFunction && element.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD || parent instanceof JSClass && element.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            JSQualifiedNamedElement initializedElement;
            if (parent instanceof JSExpression && (initializedElement = JSStubBasedPsiTreeUtil.getInitializedElement((JSExpression)parent)) != null) {
                return initializedElement;
            }
            return parent;
        }
        return null;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getGotoDeclarationTarget"));
        }
        PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateTargetElement(element);
        if (meaningfulElement != element) {
            return meaningfulElement;
        }
        return null;
    }
}

