/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Producer;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMinifiedFileUtil {
    private static final Key<CachedMinifiedStatus> CACHED_MINIFIED_STATUS_KEY = Key.create((String)"js.cached.minified.status");
    private static final TokenSet NO_WHITESPACE_REQUIRED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)JSKeywordSets.IDENTIFIER_NAMES), TokenSet.andNot((TokenSet)JSTokenTypes.COMMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT})), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.ANY_IDENTIFIER})});
    private static final TokenSet NO_WHITESPACE_REQUIRED_BEFORE = TokenSet.orSet((TokenSet[])new TokenSet[]{NO_WHITESPACE_REQUIRED_AFTER, JSTokenTypes.COMMENTS, JSTokenTypes.STRING_LITERALS});
    private static final TokenSet STRING_LITERAL_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART})});

    public static boolean isFileMinified(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSMinifiedFileUtil", "isFileMinified"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/JSMinifiedFileUtil", "isFileMinified"));
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        ThreeState isExplicitlyCompact = libraryManager.getFileState(file);
        if (isExplicitlyCompact == ThreeState.YES) {
            return true;
        }
        if (isExplicitlyCompact == ThreeState.NO) {
            return false;
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    public static boolean isFileContentMinified(@NotNull VirtualFile file) {
        long documentTimeStamp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSMinifiedFileUtil", "isFileContentMinified"));
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)file).getFileInfo();
            if (info == null || info.getState() != RemoteFileState.DOWNLOADED) {
                return false;
            }
            VirtualFile localFile = info.getLocalFile();
            if (localFile == null) {
                return false;
            }
            file = localFile;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        CachedMinifiedStatus status = (CachedMinifiedStatus)CACHED_MINIFIED_STATUS_KEY.get((UserDataHolder)file);
        long l = documentTimeStamp = document != null ? document.getModificationStamp() : -1L;
        if (status == null || status.getFileTimeStamp() != file.getTimeStamp() || status.getDocumentTimeStamp() != documentTimeStamp) {
            status = new CachedMinifiedStatus(JSMinifiedFileUtil.calcFileContentMinified(file, document), file.getTimeStamp(), documentTimeStamp);
            CACHED_MINIFIED_STATUS_KEY.set((UserDataHolder)file, (Object)status);
        }
        return status.isMinified();
    }

    private static boolean calcFileContentMinified(@NotNull VirtualFile file, @Nullable Document document) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSMinifiedFileUtil", "calcFileContentMinified"));
        }
        return JSMinifiedFileUtil.isFileContentMinified(file.getName(), (Producer<CharSequence>)((NotNullProducer)() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSMinifiedFileUtil", "lambda$calcFileContentMinified$0"));
            }
            if (document != null) {
                return document.getCharsSequence();
            }
            return LoadTextUtil.loadText((VirtualFile)file);
        }));
    }

    public static boolean isFileContentMinified(@NotNull String fileName, @NotNull Producer<CharSequence> fileContent) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/JSMinifiedFileUtil", "isFileContentMinified"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/JSMinifiedFileUtil", "isFileContentMinified"));
        }
        if (FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) != JavaScriptFileType.INSTANCE) {
            return false;
        }
        if (fileName.contains(".min.")) {
            return true;
        }
        if (fileName.contains(".dev.")) {
            return false;
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        CharSequence content = (CharSequence)fileContent.produce();
        if (content == null) {
            return false;
        }
        return MinifiedFilesUtil.isMinified((CharSequence)content, (ParserDefinition)def, (TokenSet)NO_WHITESPACE_REQUIRED_BEFORE, (TokenSet)NO_WHITESPACE_REQUIRED_AFTER, (TokenSet)STRING_LITERAL_TYPES);
    }

    private static class CachedMinifiedStatus {
        private final boolean myMinified;
        private final long myFileTimeStamp;
        private final long myDocumentTimeStamp;

        public CachedMinifiedStatus(boolean minified, long fileTimeStamp, long documentTimeStamp) {
            this.myMinified = minified;
            this.myFileTimeStamp = fileTimeStamp;
            this.myDocumentTimeStamp = documentTimeStamp;
        }

        public boolean isMinified() {
            return this.myMinified;
        }

        public long getFileTimeStamp() {
            return this.myFileTimeStamp;
        }

        public long getDocumentTimeStamp() {
            return this.myDocumentTimeStamp;
        }

        public String toString() {
            return "minified: " + this.myMinified + ", fileTimeStamp: " + this.myFileTimeStamp + ", documentTimeStamp: " + this.myDocumentTimeStamp;
        }
    }
}

