/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JSLanguageDialect
extends Language {
    private final DialectOptionHolder myDialectOptionsHolder;

    public JSLanguageDialect(@NonNls @NotNull String id, @NotNull DialectOptionHolder dialectOptionsHolder, String ... mimeTypes) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/lang/javascript/JSLanguageDialect", "<init>"));
        }
        if (dialectOptionsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectOptionsHolder", "com/intellij/lang/javascript/JSLanguageDialect", "<init>"));
        }
        this(id, dialectOptionsHolder, (Language)JavascriptLanguage.INSTANCE, mimeTypes);
    }

    public JSLanguageDialect(@NonNls @NotNull String id, @NotNull DialectOptionHolder dialectOptionsHolder, Language baseLanguage, String ... mimeTypes) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/lang/javascript/JSLanguageDialect", "<init>"));
        }
        if (dialectOptionsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectOptionsHolder", "com/intellij/lang/javascript/JSLanguageDialect", "<init>"));
        }
        super(baseLanguage, id, mimeTypes);
        this.myDialectOptionsHolder = dialectOptionsHolder;
        if (baseLanguage != JavascriptLanguage.INSTANCE) {
            JavascriptLanguage.INSTANCE.getDialects().add(this);
        }
    }

    @NonNls
    public abstract String getFileExtension();

    @NotNull
    public final DialectOptionHolder getOptionHolder() {
        DialectOptionHolder dialectOptionHolder = this.myDialectOptionsHolder;
        if (dialectOptionHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageDialect", "getOptionHolder"));
        }
        return dialectOptionHolder;
    }

    public JavaScriptParser<?, ?, ?, ?> createParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/JSLanguageDialect", "createParser"));
        }
        return new JavaScriptParser(this, builder);
    }
}

