/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSInjectionController {
    public static final int MAX_LITERAL_PROCESSING_SIZE = 4096;

    static boolean willInjectJs(PsiElement host) {
        if (host instanceof JSLiteralExpression && ((JSLiteralExpression)host).isQuotedLiteral()) {
            JSExpression[] args;
            JSQualifiedName name;
            PsiElement hostParent = host.getParent();
            JSReferenceExpression expression = JSUtils.getMethodNameIfInsideCall(hostParent);
            JSQualifiedName jSQualifiedName = name = expression != null ? JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression) : null;
            if (name != null && ("setInterval".equals(name.getName()) || "setTimeout".equals(name.getName())) && (name.getParent() == null || name.getParent().getParent() == null && "window".equals(name.getParent().getName())) && hostParent instanceof JSArgumentList && (args = ((JSArgumentList)hostParent).getArguments()).length > 0 && args[0] == host) {
                return true;
            }
        }
        return false;
    }

    public static boolean willInjectSomething(PsiElement host) {
        return JSInjectionController.willInjectHtml(host) || JSInjectionController.willInjectJs(host) || JSInjectionController.willInjectCss(host);
    }

    public static boolean willInjectCss(PsiElement host) {
        ASTNode node = host.getNode();
        if (node == null) {
            return false;
        }
        if (node.getTextLength() >= 4096) {
            return false;
        }
        if (JavaScriptReferenceContributor.isLiteralInCssContext(host, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(node);
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(ASTNode node) {
        String textWithoutQuotes;
        if (node.textContains('?')) {
            return false;
        }
        if (node.textContains('%')) {
            return false;
        }
        String text = node.getText();
        if (text.contains("##")) {
            return false;
        }
        if (node.textContains('#')) {
            int diesIndex = text.indexOf(35);
            while (diesIndex > 0 && (text.charAt(diesIndex - 1) == '\'' || text.charAt(diesIndex - 1) != '=')) {
                diesIndex = text.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text.contains("[]")) {
            return false;
        }
        int eqPos = text.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text.length() && Character.isWhitespace(text.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text.length() && Character.isDigit(text.charAt(valuePos))) {
                return false;
            }
        }
        if ((textWithoutQuotes = StringUtil.stripQuotesAroundValue((String)text)).startsWith(">")) {
            return false;
        }
        return !JavaScriptReferenceContributor.isSimpleCss(textWithoutQuotes);
    }

    public static boolean willInjectHtml(PsiElement host) {
        PsiElement parent = host.getParent();
        PsiElement hostExpression = host;
        while (parent instanceof JSBinaryExpression || parent instanceof JSParenthesizedExpression) {
            hostExpression = parent;
            parent = parent.getParent();
        }
        if (!DialectDetector.isActionScript(hostExpression) && hostExpression.getTextLength() < 4096) {
            if (!hostExpression.textContains('<')) {
                return false;
            }
            String text = hostExpression instanceof JSStringTemplateExpression ? new JSQuotedLiteralInjector((JSLiteralExpression)((JSStringTemplateExpression)hostExpression)).getInjectedText() : hostExpression.getText();
            int length = text.length();
            int tagStart = text.indexOf(60);
            return tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-') && text.indexOf(62, tagStart) > 0 && !JSInjectionController.hasOuterLanguage(hostExpression);
        }
        return false;
    }

    protected static boolean hasOuterLanguage(PsiElement host) {
        final Ref result = Ref.create((Object)false);
        host.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof OuterLanguageElement) {
                    result.set((Object)true);
                    this.stopWalking();
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)result.get();
    }

    public static void getLanguagesToInjectStatic(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSInjectionController", "getLanguagesToInjectStatic"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSInjectionController", "getLanguagesToInjectStatic"));
        }
        for (MultiHostInjector injector : (MultiHostInjector[])Extensions.getExtensions((ExtensionPointName)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, (AreaInstance)host.getProject())) {
            if (!(injector instanceof JSTargetedInjector)) continue;
            injector.getLanguagesToInject(registrar, host);
        }
    }

    static class JSQuotedLiteralInjector {
        private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";
        @NotNull
        private final JSLiteralExpression myQuotedLiteral;

        public JSQuotedLiteralInjector(@NotNull JSLiteralExpression quotedLiteral) {
            if (quotedLiteral == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedLiteral", "com/intellij/lang/javascript/JSInjectionController$JSQuotedLiteralInjector", "<init>"));
            }
            this.myQuotedLiteral = quotedLiteral;
        }

        public String getInjectedText() {
            String text = this.myQuotedLiteral.getText();
            StringBuilder result = new StringBuilder();
            for (Trinity<String, TextRange, String> place : this.getPlaces()) {
                if (place.first != null) {
                    result.append((String)place.first);
                }
                result.append(text.substring(((TextRange)place.second).getStartOffset(), ((TextRange)place.second).getEndOffset()));
                if (place.third == null) continue;
                result.append((String)place.third);
            }
            return result.toString();
        }

        public List<Trinity<String, TextRange, String>> getPlaces() {
            TextRange[] ranges;
            if (this.myQuotedLiteral instanceof JSStringTemplateExpression && (ranges = ((JSStringTemplateExpression)this.myQuotedLiteral).getStringRanges()).length > 0) {
                ArrayList<Trinity<String, TextRange, String>> result = new ArrayList<Trinity<String, TextRange, String>>(ranges.length);
                ASTNode quotedLiteralNode = this.myQuotedLiteral.getNode();
                ASTNode backquote = quotedLiteralNode.findChildByType(JSTokenTypes.BACKQUOTE);
                int backquoteOffset = backquote != null ? backquote.getStartOffset() - quotedLiteralNode.getStartOffset() : -1;
                for (int i = 0; i < ranges.length; ++i) {
                    TextRange range = ranges[i];
                    String prefix = i == 0 && range.getStartOffset() > backquoteOffset + 1 ? EXTERNAL_FRAGMENT : null;
                    String suffix = i < ranges.length - 1 || range.getEndOffset() < this.myQuotedLiteral.getTextLength() - 1 ? EXTERNAL_FRAGMENT : null;
                    result.add((Trinity<String, TextRange, String>)Trinity.create((Object)prefix, (Object)range, (Object)suffix));
                }
                return result;
            }
            int endOffset = Math.max(this.myQuotedLiteral.getTextLength() - 1, 1);
            return Collections.singletonList(Trinity.create((Object)null, (Object)TextRange.create((int)1, (int)endOffset), (Object)null));
        }

        public void addPlaces(MultiHostRegistrar registrar, String prefix, String suffix) {
            boolean first = true;
            Iterator<Trinity<String, TextRange, String>> iterator = this.getPlaces().iterator();
            while (iterator.hasNext()) {
                Trinity<String, TextRange, String> trinity = iterator.next();
                String placePrefix = (String)trinity.first;
                String placeSuffix = (String)trinity.third;
                if (first && prefix != null) {
                    placePrefix = placePrefix == null ? prefix : prefix + placePrefix;
                }
                first = false;
                if (!iterator.hasNext() && suffix != null) {
                    placeSuffix = placeSuffix == null ? suffix : placeSuffix + suffix;
                }
                registrar.addPlace(placePrefix, placeSuffix, (PsiLanguageInjectionHost)this.myQuotedLiteral, (TextRange)trinity.second);
            }
        }
    }
}

