/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.findUsages.JSFindReferencesResultProcessor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6ImportAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher", "processQuery"));
        }
        PsiElement target = queryParameters.getElementToSearch();
        if (!(target instanceof JSElement) || !(target instanceof PsiNamedElement)) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(target);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return;
        }
        SearchRequestCollector collector = queryParameters.getOptimizer();
        String name = ((PsiNamedElement)target).getName();
        if (name != null) {
            collector.searchWord(name, queryParameters.getEffectiveSearchScope(), (short)1, true, target, (RequestResultProcessor)new MyProcessor(target, queryParameters));
        }
    }

    private static class MyProcessor
    extends JSFindReferencesResultProcessor {
        MyProcessor(PsiElement target, ReferencesSearch.SearchParameters queryParameters) {
            super(target, queryParameters);
        }

        @Override
        protected boolean proceedWithReference(@NotNull PsiElement element, SearchRequestCollector collector) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher$MyProcessor", "proceedWithReference"));
            }
            JSNamedElement alias = MyProcessor.getAlias(element);
            if (alias == null || alias.getName() == null) {
                return false;
            }
            String name = alias.getName();
            LocalSearchScope fileScope = new LocalSearchScope((PsiElement)element.getContainingFile());
            collector.searchWord(name, (SearchScope)fileScope, (short)1, true, (PsiElement)alias);
            return true;
        }

        @Nullable
        private static JSNamedElement getAlias(PsiElement element) {
            TypeScriptImportStatement importStatement;
            if (element instanceof ES6ImportSpecifier) {
                ES6ImportSpecifierAlias alias = ((ES6ImportSpecifier)element).getAlias();
                if (alias != null) {
                    return alias;
                }
            } else if (element instanceof TypeScriptEntityName && !(element.getParent() instanceof TypeScriptEntityName) && (importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptImportStatement.class)) != null) {
                return importStatement;
            }
            return null;
        }
    }
}

