/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ES6MemberCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        if (!(parent instanceof JSField)) {
            return;
        }
        JSField field = (JSField)parent;
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)field);
        if (containingClass == null) {
            return;
        }
        final HashSet existingMembers = ContainerUtil.newHashSet();
        for (JSElement o : containingClass.getMembers()) {
            String name = o.getName();
            if (name == null) continue;
            existingMembers.add(name);
        }
        final HashMap forCompletion = ContainerUtil.newHashMap();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider$1", "process"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider$1", "process"));
                }
                if (aClass.isEquivalentTo((PsiElement)containingClass)) {
                    return true;
                }
                for (JSFunction function : aClass.getFunctions()) {
                    JSContext jsContext;
                    String name = function.getName();
                    if (name == null || existingMembers.contains(name) || forCompletion.containsKey(name) || (jsContext = function.getJSContext()) == JSContext.STATIC) continue;
                    forCompletion.put(name, function);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        forCompletion.values().forEach(el -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider", "lambda$addCompletions$0"));
            }
            result.consume(ES6MemberCompletionProvider.createLookupElement(el));
        });
    }

    private static LookupElement createLookupElement(@NotNull JSElement function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/ecmascript6/completion/ES6MemberCompletionProvider", "createLookupElement"));
        }
        String name = function.getName();
        assert (name != null);
        return LookupElementBuilder.create((Object)function, (String)name);
    }
}

