/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__CONFIG_FILE = "config";
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
        }
        Object location = PROTOCOL_ID__CONFIG_FILE.equals(protocol) ? ProtractorTestLocationProvider.getConfigLocation(project, path) : (PROTOCOL_ID__TEST_SUITE.equals(protocol) ? ProtractorTestLocationProvider.getTestLocation(project, path, true) : (PROTOCOL_ID__TEST.equals(protocol) ? ProtractorTestLocationProvider.getTestLocation(project, path, false) : null));
        if (location != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static Location<PsiFile> getConfigLocation(@NotNull Project project, @NotNull String locationData) {
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getConfigLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getConfigLocation"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)locationData));
        if (virtualFile != null && virtualFile.isValid() && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && psiFile.isValid()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        return null;
    }

    @Nullable
    private static Location getTestLocation(@NotNull Project project, @NotNull String locationData, boolean isSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getTestLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "getTestLocation"));
        }
        List path = EscapeUtils.split((String)locationData, (char)'.');
        if (path.isEmpty()) {
            return null;
        }
        PsiElement element = ProtractorTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.JASMINE, path));
        if (element == null) {
            element = ProtractorTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.QUNIT, path));
        }
        return element != null ? PsiLocation.fromPsiElement((PsiElement)element) : null;
    }

    @Nullable
    private static PsiElement findFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn) {
        block5: {
            List jsTestVirtualFiles;
            block4: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "findFqnElement"));
                }
                if (testFqn == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFqn", "com/intellij/javascript/protractor/ProtractorTestLocationProvider", "findFqnElement"));
                }
                GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
                jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, null);
                if (testFqn.getType() != JSTestFileType.JASMINE) break block4;
                JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
                for (VirtualFile file : jsTestVirtualFiles) {
                    JasmineFileStructure jasmineFileStructure;
                    PsiElement element;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    if (!(psiFile instanceof JSFile) || (element = (jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(testFqn.getNames(), null)) == null || !element.isValid()) continue;
                    return element;
                }
                break block5;
            }
            if (testFqn.getType() != JSTestFileType.QUNIT) break block5;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            for (VirtualFile file : jsTestVirtualFiles) {
                PsiElement element;
                String testMethodName;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof JSFile)) continue;
                QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile);
                String testCaseName = (String)ContainerUtil.getFirstItem((List)testFqn.getNames());
                String string = testMethodName = testFqn.getNames().size() > 1 ? (String)testFqn.getNames().get(1) : null;
                if (testCaseName == null || (element = qunitFileStructure.findPsiElement(testCaseName, testMethodName)) == null || !element.isValid()) continue;
                return element;
            }
        }
        return null;
    }
}

