/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreterUtil {
    private static final String NODE_INTERPRETER_BASE_NAME = SystemInfo.isWindows ? "node.exe" : "node";
    private static final FileFilter NODE_FILTER = pathname -> {
        String path;
        if (SystemInfo.isWindows && (path = pathname.getAbsolutePath()).contains("Microsoft HPC Pack")) {
            return false;
        }
        return !SystemInfo.isUnix || !"/usr/sbin/node".equals(path = pathname.getAbsolutePath());
    };

    private NodeJsLocalInterpreterUtil() {
    }

    @Nullable
    public static File findInterpreterInPath() {
        File interpreter = PathEnvironmentVariableUtil.findInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        if (interpreter != null) {
            return interpreter;
        }
        ArrayList interpreters = ContainerUtil.newArrayList();
        NodeJsLocalInterpreterUtil.addNodeInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.listNodeInterpretersFromHomeBrew(interpreters);
        if (interpreters.size() == 1) {
            return (File)ContainerUtil.getFirstItem((List)interpreters);
        }
        return null;
    }

    @NotNull
    public static List<File> detectAllLocalInterpreters() {
        List fromPath = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        ArrayList interpreters = ContainerUtil.newArrayList((Iterable)fromPath);
        NodeJsLocalInterpreterUtil.addNodeInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.listNodeInterpretersFromHomeBrew(interpreters);
        NodeJsLocalInterpreterUtil.listNodeInterpretersFromNodist(interpreters);
        ArrayList arrayList = interpreters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "detectAllLocalInterpreters"));
        }
        return arrayList;
    }

    private static void listNodeInterpretersFromNodist(@NotNull List<File> interpreters) {
        File versionsDir;
        String nodistPrefix;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "listNodeInterpretersFromNodist"));
        }
        if (SystemInfo.isWindows && !StringUtil.isEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX"))) && (versionsDir = new File(nodistPrefix, "v")).isAbsolute() && versionsDir.isDirectory()) {
            NodeJsLocalInterpreterUtil.addNodeInterpretersFromVersionDir(interpreters, versionsDir, false);
        }
    }

    private static void addNodeInterpretersFromNvm(@NotNull List<File> interpreters) {
        File nvmDir;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addNodeInterpretersFromNvm"));
        }
        String nvmDirPath = EnvironmentUtil.getValue((String)"NVM_DIR");
        if (StringUtil.isEmpty((String)nvmDirPath)) {
            if (SystemInfo.isUnix) {
                nvmDirPath = SystemProperties.getUserHome() + "/.nvm";
            } else {
                return;
            }
        }
        if (!(nvmDir = new File(nvmDirPath)).isAbsolute()) {
            return;
        }
        NodeJsLocalInterpreterUtil.addNodeInterpretersFromVersionDir(interpreters, nvmDir, true);
        File versionsDir = new File(nvmDir, "versions");
        if (versionsDir.isDirectory()) {
            NodeJsLocalInterpreterUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "node"), true);
            NodeJsLocalInterpreterUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "io.js"), true);
        }
    }

    private static void listNodeInterpretersFromHomeBrew(@NotNull List<File> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "listNodeInterpretersFromHomeBrew"));
        }
        NodeJsLocalInterpreterUtil.addNodeInterpretersFromVersionDir(interpreters, new File("/usr/local/Cellar/node"), true);
    }

    private static void addNodeInterpretersFromVersionDir(@NotNull List<File> interpreters, @NotNull File parentDir, boolean insideBinDir) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addNodeInterpretersFromVersionDir"));
        }
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addNodeInterpretersFromVersionDir"));
        }
        if (!parentDir.isDirectory()) {
            return;
        }
        File[] dirs = parentDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String relativePath;
            File interpreter;
            SemVer semVer = NodeJsLocalInterpreterUtil.parseSemVer(dir.getName());
            if (semVer == null || !(interpreter = new File(dir, relativePath = insideBinDir ? "bin" + File.separator + NODE_INTERPRETER_BASE_NAME : NODE_INTERPRETER_BASE_NAME)).isFile() || !interpreter.canExecute()) continue;
            interpreters.add(interpreter);
        }
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "parseSemVer"));
        }
        return SemVer.parseFromText((String)StringUtil.trimStart((String)name, (String)"v"));
    }
}

