/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class NodeJsInterpreter {
    @NotNull
    public abstract NodeJsInterpreterType<? extends NodeJsInterpreter> getType();

    @NotNull
    public abstract String getReferenceName();

    @NotNull
    public abstract String getPresentableName();

    @Nullable
    public abstract Ref<SemVer> getCachedVersion();

    public abstract void fetchVersion(@NotNull NullableConsumer<SemVer> var1);

    public void provideCachedVersionOrFetch(@NotNull NullableConsumer<SemVer> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter", "provideCachedVersionOrFetch"));
        }
        Ref<SemVer> versionRef = this.getCachedVersion();
        if (versionRef != null) {
            consumer.consume(versionRef.get());
        } else {
            this.fetchVersion(consumer);
        }
    }

    @NotNull
    public Promise<SemVer> provideCachedVersionOrFetch() {
        AsyncPromise promise = new AsyncPromise();
        this.provideCachedVersionOrFetch((NullableConsumer<SemVer>)((NullableConsumer)ver -> promise.setResult(ver)));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter", "provideCachedVersionOrFetch"));
        }
        return asyncPromise;
    }

    @Nullable
    public abstract String validate(@NotNull Project var1);

    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other);
    }

    @Nullable
    public static NodeJsInterpreter tryCast(@Nullable Object obj) {
        return (NodeJsInterpreter)ObjectUtils.tryCast((Object)obj, NodeJsInterpreter.class);
    }

    public final String getOldPath() {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(this);
        if (localInterpreter != null) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast(this);
        if (remoteInterpreter != null) {
            return remoteInterpreter.getRemoteUrl();
        }
        return this.getReferenceName();
    }
}

