/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeStackTraceFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeStacktraceFinder();
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "<init>"));
        }
        this(project, null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "<init>"));
        }
        super(project, baseDir != null ? baseDir.getAbsolutePath() : null);
        this.myCoreLibraryManager = NodeJsCoreLibraryManager.getInstance(project);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "parse"));
        }
        List list = FINDER.find(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "parse"));
        }
        return list;
    }

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "findFile"));
        }
        VirtualFile file = super.findFile(filePath);
        if (file == null) {
            file = this.myCoreLibraryManager.findCoreModuleFileByName(FileUtilRt.getNameWithoutExtension((String)filePath));
        }
        return file;
    }

    private static class NodeStacktraceFinder
    implements FileHyperlinkRawDataFinder {
        private static final String BABEL_SYNTAX_ERROR = "SyntaxError:";
        private static final PatternBasedFileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+(.+?):(\\d+)(:\\d+)?\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+.*\\((.+?):(\\d+)(:\\d+)?\\)\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeStacktraceFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "find"));
            }
            List result = PATTERN_FINDER.find(line);
            if (!result.isEmpty()) {
                List list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "find"));
                }
                return list;
            }
            FileHyperlinkRawData data = NodeStacktraceFinder.parseAsBabelError(line);
            List list = ContainerUtil.createMaybeSingletonList((Object)data);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "find"));
            }
            return list;
        }

        @Nullable
        private static FileHyperlinkRawData parseAsBabelError(@NotNull String line) {
            int pathStartInd;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "parseAsBabelError"));
            }
            int syntaxErrorInd = line.indexOf(BABEL_SYNTAX_ERROR);
            if (syntaxErrorInd == -1) {
                return null;
            }
            if (syntaxErrorInd > 0 && !Character.isWhitespace(line.charAt(syntaxErrorInd - 1))) {
                return null;
            }
            for (pathStartInd = syntaxErrorInd + BABEL_SYNTAX_ERROR.length(); pathStartInd < line.length() && Character.isWhitespace(line.charAt(pathStartInd)); ++pathStartInd) {
            }
            int pathEndInd = line.indexOf(": ", pathStartInd + 1);
            if (pathEndInd == -1) {
                return null;
            }
            while (pathEndInd > 0 && Character.isWhitespace(line.charAt(pathEndInd - 1))) {
                --pathEndInd;
            }
            int columnEndInd = line.lastIndexOf(41);
            if (columnEndInd == -1) {
                return null;
            }
            int columnStartInd = NodeStacktraceFinder.findNumberStartInd(line, columnEndInd);
            if (columnStartInd == -1) {
                return null;
            }
            int lineEndInd = columnStartInd - 1;
            if (line.charAt(lineEndInd) != ':') {
                return null;
            }
            int lineStartInd = NodeStacktraceFinder.findNumberStartInd(line, lineEndInd);
            if (lineStartInd == -1) {
                return null;
            }
            int lineNumber = NodeStacktraceFinder.parseNumber(line, lineStartInd, lineEndInd);
            int columnNumber = NodeStacktraceFinder.parseNumber(line, columnStartInd, columnEndInd);
            if (lineNumber <= 0 || columnNumber <= 0) {
                return null;
            }
            return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), lineNumber - 1, columnNumber - 1, pathStartInd, columnEndInd + 1);
        }

        private static int findNumberStartInd(@NotNull String line, int digitEndInd) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "findNumberStartInd"));
            }
            int digitStartInd = digitEndInd - 1;
            if (digitStartInd < 0 || !Character.isDigit(line.charAt(digitStartInd))) {
                return -1;
            }
            while (digitStartInd > 0 && Character.isDigit(line.charAt(digitStartInd - 1))) {
                --digitStartInd;
            }
            return digitStartInd;
        }

        private static int parseNumber(@NotNull String line, int startInd, int endInd) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder", "parseNumber"));
            }
            if (startInd < 0 || startInd >= endInd || endInd > line.length()) {
                return -1;
            }
            return StringUtil.parseInt((String)line.substring(startInd, endInd), (int)-1);
        }
    }
}

