/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeConsoleAdditionalFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeAdditionalFinder();

    public NodeConsoleAdditionalFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "<init>"));
        }
        super(project, null);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parse"));
        }
        List list = FINDER.find(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parse"));
        }
        return list;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLink(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parseFirefoxLikeLink"));
        }
        int startIndex = line.indexOf("@(");
        while (startIndex >= 0) {
            FileHyperlinkRawData result = NodeConsoleAdditionalFilter.parseFirefoxLikeLinkAt(line, startIndex + 2);
            if (result != null) {
                return result;
            }
            startIndex = line.indexOf("@(", startIndex + 2);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLinkAt(@NotNull String line, int pathStartInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parseFirefoxLikeLinkAt"));
        }
        int length = line.length();
        int pathEndInd = line.indexOf(58, pathStartInd);
        if (pathEndInd > 0 && pathEndInd - pathStartInd > 3) {
            int lineStartInd;
            int lineEndInd;
            for (lineEndInd = lineStartInd = pathEndInd + 1; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
            }
            if (lineStartInd == lineEndInd) {
                return null;
            }
            int documentColumn = -1;
            int closeParenInd = lineEndInd;
            if (lineEndInd < length && line.charAt(lineEndInd) == ':') {
                int columnStartInd;
                int columnEndInd;
                for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
                }
                if (columnStartInd == columnEndInd) {
                    return null;
                }
                documentColumn = StringUtil.parseInt((String)line.substring(columnStartInd, columnEndInd), (int)-1) - 1;
                closeParenInd = columnEndInd;
            }
            if (closeParenInd < length && line.charAt(closeParenInd) == ')') {
                int documentLine = StringUtil.parseInt((String)line.substring(lineStartInd, lineEndInd), (int)-1) - 1;
                return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), documentLine, documentColumn, pathStartInd, closeParenInd);
            }
        }
        return null;
    }

    private static class NodeAdditionalFinder
    implements FileHyperlinkRawDataFinder {
        private static final FileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:>> )?\\s*([/\\w].*?):(\\d+)(:\\d+)?(?:\\s|: |$)"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeAdditionalFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder", "find"));
            }
            FileHyperlinkRawData data = NodeConsoleAdditionalFilter.parseFirefoxLikeLink(line);
            if (data != null) {
                List<FileHyperlinkRawData> list = Collections.singletonList(data);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder", "find"));
                }
                return list;
            }
            List list = PATTERN_FINDER.find(line);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder", "find"));
            }
            return list;
        }
    }
}

