/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNodeBinFileVersionManager {
    private final Map<String, TimestampedVersion> myCache = Collections.synchronizedMap(new LinkedHashMap<String, TimestampedVersion>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimestampedVersion> eldest) {
            return this.size() > 10;
        }
    });

    @NotNull
    public SemVer getVersion(@NotNull String nodeInterpreter, @NotNull File binFile, @NotNull List<String> arguments, long timeoutMillis) throws ExecutionException {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "getVersion"));
        }
        if (binFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binFile", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "getVersion"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "getVersion"));
        }
        if (!binFile.isFile()) {
            throw new ExecutionException("File " + binFile.getAbsolutePath() + " does not exist");
        }
        long lastModified = binFile.lastModified();
        String binFilePath = binFile.getAbsolutePath();
        TimestampedVersion r = this.myCache.get(binFilePath);
        if (r == null || r.getTimestamp() != lastModified) {
            String stdout = AbstractNodeBinFileVersionManager.runAndGetStdout(nodeInterpreter, binFile, arguments, timeoutMillis);
            r = new TimestampedVersion(lastModified, this.parse(stdout));
            this.myCache.put(binFilePath, r);
        }
        SemVer semVer = r.getVersion();
        if (semVer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "getVersion"));
        }
        return semVer;
    }

    @NotNull
    private static String runAndGetStdout(@NotNull String nodeInterpreter, @NotNull File binFile, @NotNull List<String> arguments, long timeoutMillis) throws ExecutionException {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "runAndGetStdout"));
        }
        if (binFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binFile", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "runAndGetStdout"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "runAndGetStdout"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(nodeInterpreter);
        commandLine.addParameter(binFile.getAbsolutePath());
        commandLine.addParameters(arguments);
        ProcessOutput output = NodeCommandLineUtil.execute(commandLine, TimeUnit.SECONDS.toMillis(timeoutMillis));
        if (output.isTimeout()) {
            throw new ExecutionException("Cannot fetch version of " + binFile.getAbsolutePath() + ": timed out after " + timeoutMillis + " ms");
        }
        String string = output.getStdout();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager", "runAndGetStdout"));
        }
        return string;
    }

    @NotNull
    protected abstract SemVer parse(@NotNull String var1) throws ExecutionException;

    private static class TimestampedVersion {
        private final long myTimestamp;
        private final SemVer myVersion;

        /*
         * WARNING - void declaration
         */
        private TimestampedVersion(long timestamp, @NotNull SemVer semVer) {
            void version;
            if (semVer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager$TimestampedVersion", "<init>"));
            }
            this.myTimestamp = timestamp;
            this.myVersion = version;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        @NotNull
        public SemVer getVersion() {
            SemVer semVer = this.myVersion;
            if (semVer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/AbstractNodeBinFileVersionManager$TimestampedVersion", "getVersion"));
            }
            return semVer;
        }
    }
}

