/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorBuilder;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSEquivalenceDescriptorProvider
extends EquivalenceDescriptorProvider {
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dupLocator/JSEquivalenceDescriptorProvider", "isMyContext"));
        }
        return context.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public EquivalenceDescriptor buildDescriptor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JSEquivalenceDescriptorProvider", "buildDescriptor"));
        }
        EquivalenceDescriptorBuilder builder = new EquivalenceDescriptorBuilder();
        if (element instanceof JSClass) {
            JSClass c = (JSClass)element;
            JSReferenceList extendsList = c.getExtendsList();
            JSReferenceList implementsList = c.getImplementsList();
            return builder.element(c.getNameIdentifier()).childrenOptionally((PsiElement)c.getAttributeList()).inAnyOrder((PsiElement[])(extendsList != null ? extendsList.getExpressions() : PsiElement.EMPTY_ARRAY)).inAnyOrder((PsiElement[])(implementsList != null ? implementsList.getExpressions() : PsiElement.EMPTY_ARRAY)).inAnyOrder((PsiElement[])c.getFields()).inAnyOrder((PsiElement[])c.getFunctions());
        }
        if (element instanceof JSVariable) {
            JSVariable v = (JSVariable)element;
            return builder.element(v.getNameIdentifier()).optionally(v.getTypeElement()).optionallyInPattern((PsiElement)v.getInitializer());
        }
        if (element instanceof JSFunction) {
            JSFunction f = (JSFunction)element;
            return builder.constant((Object)f.getKind().toString()).element(f.getNameIdentifier()).childrenOptionally((PsiElement)f.getAttributeList()).children((PsiElement)f.getParameterList()).optionally(f.getReturnTypeElement()).optionallyInPattern((PsiElement[])f.getBody());
        }
        if (element instanceof JSBlockStatement) {
            if (!(element.getParent() instanceof JSFunction)) {
                return builder.codeBlock((PsiElement[])((JSBlockStatement)element).getStatements());
            }
        } else if (element instanceof JSParenthesizedExpression) {
            return builder.element((PsiElement)((JSParenthesizedExpression)element).getInnerExpression());
        }
        return null;
    }
}

