/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsdUtil {
    public static final String ELEMENT = "element";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String SIMPLE_TYPE = "simpleType";

    private XsdUtil() {
    }

    public static Map<String, XsdElement> getChildrenElements(@NotNull XmlElement xsdElement, @NotNull String namespace) {
        if (xsdElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xsdElement", "com/intellij/spring/ws/util/XsdUtil", "getChildrenElements"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil", "getChildrenElements"));
        }
        HashMap<String, XsdElement> set = new HashMap<String, XsdElement>();
        xsdElement.acceptChildren((PsiElementVisitor)new XmlRecursiveXsdElementVisitor(XsdElementsCollectProcessors.getCollectProcessor(namespace, set)));
        return set;
    }

    public static XsdElement findXsdElement(@NotNull XmlElement xsdElement, @NotNull String namespace, @NotNull String elementName) {
        if (xsdElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xsdElement", "com/intellij/spring/ws/util/XsdUtil", "findXsdElement"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil", "findXsdElement"));
        }
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/intellij/spring/ws/util/XsdUtil", "findXsdElement"));
        }
        return XsdUtil.getChildrenElements(xsdElement, namespace).get(elementName);
    }

    private static class XmlRecursiveXsdElementVisitor
    extends XmlRecursiveElementVisitor {
        private Processor<XmlTag> myProcessor;

        public XmlRecursiveXsdElementVisitor(@NotNull Processor<XmlTag> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/ws/util/XsdUtil$XmlRecursiveXsdElementVisitor", "<init>"));
            }
            this.myProcessor = processor;
        }

        public void visitXmlTag(XmlTag tag) {
            if (XsdUtil.ELEMENT.equals(tag.getLocalName())) {
                if (this.myProcessor.process((Object)tag)) {
                    super.visitXmlTag(tag);
                } else {
                    return;
                }
            }
            super.visitXmlTag(tag);
        }
    }

    private static abstract class XsdElementsCollectProcessors
    implements Processor<XmlTag> {
        private final Map<String, XsdElement> mySet;
        private final String myNamespace;

        public static XsdElementsCollectProcessors getCollectAllProcessor(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "getCollectAllProcessor"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "getCollectAllProcessor"));
            }
            return new XsdElementsCollectProcessors(namespace, (Map)set){

                @Override
                protected boolean isCollectChildren() {
                    return true;
                }
            };
        }

        public static XsdElementsCollectProcessors getCollectProcessor(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "getCollectProcessor"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "getCollectProcessor"));
            }
            return new XsdElementsCollectProcessors(namespace, (Map)set){

                @Override
                protected boolean isCollectChildren() {
                    return false;
                }
            };
        }

        private XsdElementsCollectProcessors(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "<init>"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors", "<init>"));
            }
            this.myNamespace = namespace;
            this.mySet = set;
        }

        public boolean process(XmlTag xmlTag) {
            XmlAttribute nameElement = xmlTag.getAttribute(XsdUtil.NAME);
            if (nameElement != null) {
                String name = nameElement.getValue();
                this.mySet.put(name, new XsdElement(name, this.myNamespace, xmlTag));
            }
            return this.isCollectChildren();
        }

        protected abstract boolean isCollectChildren();
    }

    public static class XsdTypeBean {
        public static XsdTypeBean UNKNOWN = new XsdTypeBean(null);
        @Nullable
        private XmlTag myDeclaration;

        public XsdTypeBean(@Nullable XmlTag declaration) {
            this.myDeclaration = declaration;
            if (declaration != null) assert (declaration.getName().equals(XsdUtil.SIMPLE_TYPE) || declaration.getName().equals(XsdUtil.COMPLEX_TYPE));
        }

        @Nullable
        public XmlTag getDeclaration() {
            return this.myDeclaration;
        }

        @Nullable
        public String getName() {
            if (this.myDeclaration == null) {
                return null;
            }
            return this.myDeclaration.getAttributeValue(XsdUtil.NAME);
        }

        @Nullable
        public String getSimpleType() {
            if (this.myDeclaration == null || XsdUtil.COMPLEX_TYPE.equals(this.myDeclaration.getName())) {
                return null;
            }
            return this.myDeclaration.getAttributeValue("id");
        }
    }

    public static class XsdElement {
        private final String myName;
        private final String myNamespace;
        private final XmlTag declaration;

        XsdElement(@NotNull String name, @NotNull String namespace, @NotNull XmlTag element) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XsdUtil.NAME, "com/intellij/spring/ws/util/XsdUtil$XsdElement", "<init>"));
            }
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XsdUtil.ELEMENT, "com/intellij/spring/ws/util/XsdUtil$XsdElement", "<init>"));
            }
            this.myName = name;
            this.myNamespace = namespace;
            this.declaration = element;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "getName"));
            }
            return string;
        }

        @NotNull
        public String getNamespace() {
            String string = this.myNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "getNamespace"));
            }
            return string;
        }

        @NotNull
        public XmlTag getDeclaration() {
            XmlTag xmlTag = this.declaration;
            if (xmlTag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "getDeclaration"));
            }
            return xmlTag;
        }

        @NotNull
        public XsdTypeBean getType() {
            XmlTag tag;
            PsiElement element;
            PsiReference[] references;
            XmlAttribute typeAttribute = this.getDeclaration().getAttribute(XsdUtil.TYPE);
            if (typeAttribute != null && (references = typeAttribute.getReferences()).length > 0 && (element = references[references.length - 1].resolve()) instanceof XmlTag && (XsdUtil.SIMPLE_TYPE.equals((tag = (XmlTag)element).getName()) || XsdUtil.COMPLEX_TYPE.equals(tag.getName()))) {
                XsdTypeBean xsdTypeBean = new XsdTypeBean(tag);
                if (xsdTypeBean == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "getType"));
                }
                return xsdTypeBean;
            }
            XsdTypeBean xsdTypeBean = XsdTypeBean.UNKNOWN;
            if (xsdTypeBean == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/XsdUtil$XsdElement", "getType"));
            }
            return xsdTypeBean;
        }
    }
}

