/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.inspections.jam.SpringWebServiceJamModelInspectionBase;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebServiceAnnotationsInconsistencyInspection
extends SpringWebServiceJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkClass"));
        }
        SpringWebServiceEndpoint endpoint = SpringWebServiceJamUtil.getEndpoint(aClass);
        if (endpoint != null) {
            this.checkEndpoint(endpoint, holder);
        } else {
            SpringWebServiceAnnotationsInconsistencyInspection.checkClassContainsIllegalAnnotations(aClass, holder);
        }
    }

    private void checkEndpoint(@NotNull SpringWebServiceEndpoint endpoint, @NotNull ProblemsHolder holder) {
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endpoint", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkEndpoint"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkEndpoint"));
        }
        for (PsiMethod psiMethod : endpoint.getPsiElement().getMethods()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.ws.server.endpoint.annotation.PayloadRoot", (boolean)true)) continue;
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                SpringWebServiceAnnotationsInconsistencyInspection.checkPayLoadMethodAnnotations((PsiModifierListOwner)parameter, "org.springframework.ws.server.endpoint.annotation.XPathParam", holder);
            }
        }
    }

    private static void checkClassContainsIllegalAnnotations(PsiClass psiClass, ProblemsHolder holder) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            SpringWebServiceAnnotationsInconsistencyInspection.checkEndpointClassAnnotations((PsiModifierListOwner)psiMethod, "org.springframework.ws.server.endpoint.annotation.PayloadRoot", holder);
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                SpringWebServiceAnnotationsInconsistencyInspection.checkEndpointClassAnnotations((PsiModifierListOwner)parameter, "org.springframework.ws.server.endpoint.annotation.XPathParam", holder);
            }
        }
    }

    private static void checkEndpointClassAnnotations(@NotNull PsiModifierListOwner owner, @NotNull String incorrectAnnotation, @NotNull ProblemsHolder holder) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkEndpointClassAnnotations"));
        }
        if (incorrectAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incorrectAnnotation", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkEndpointClassAnnotations"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkEndpointClassAnnotations"));
        }
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{incorrectAnnotation});
        if (psiAnnotation != null) {
            holder.registerProblem((PsiElement)psiAnnotation, SpringWebServicesBundle.message("jam.name.annotation.must.be.defined.for.endpoints", StringUtil.getShortName((String)incorrectAnnotation)), new LocalQuickFix[0]);
        }
    }

    private static void checkPayLoadMethodAnnotations(@NotNull PsiModifierListOwner owner, @NotNull String incorrectAnnotation, @NotNull ProblemsHolder holder) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkPayLoadMethodAnnotations"));
        }
        if (incorrectAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incorrectAnnotation", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkPayLoadMethodAnnotations"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "checkPayLoadMethodAnnotations"));
        }
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{incorrectAnnotation});
        if (psiAnnotation != null) {
            holder.registerProblem((PsiElement)psiAnnotation, SpringWebServicesBundle.message("jam.name.annotation.must.be.defined.for.payload.methods", StringUtil.getShortName((String)incorrectAnnotation)), new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringWebServiceAnnotationsInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection", "getShortName"));
        }
        return "SpringWebServiceAnnotationsInconsistencyInspection";
    }
}

