/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.ws.converters.NamespaceReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamespacePropertyValueConverter
extends Converter<String>
implements CustomReferenceConverter<String>,
GenericDomValueConvertersRegistry.Provider,
Condition<Pair<PsiType, GenericDomValue>> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new NamespaceReference(element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/NamespacePropertyValueConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    public boolean value(Pair<PsiType, GenericDomValue> pair) {
        GenericDomValue value = (GenericDomValue)pair.getSecond();
        if (value instanceof Prop) {
            return SpringPropertyUtils.isSpecificProperty((GenericDomValue)value, (String)"namespaces", (String[])new String[]{"org.springframework.ws.server.endpoint.adapter.XPathParamAnnotationMethodEndpointAdapter"});
        }
        return false;
    }

    public Converter getConverter() {
        return this;
    }

    public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
        return this;
    }
}

