/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.annotators;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import icons.SpringApiIcons;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringWebServiceDispatcherServletGutterAnnotator
implements Annotator {
    private static void annotateMessageDispatcherServlet(@NotNull Servlet servlet, @NotNull AnnotationHolder holder) {
        if (servlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servlet", "com/intellij/spring/ws/annotators/SpringWebServiceDispatcherServletGutterAnnotator", "annotateMessageDispatcherServlet"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/annotators/SpringWebServiceDispatcherServletGutterAnnotator", "annotateMessageDispatcherServlet"));
        }
        Set<XmlFile> files = SpringWebServicesUtil.getMessageDispatcherServletContexts(servlet);
        if (files.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringConfig, ContainerUtil::createMaybeSingletonList);
            iconBuilder.setTargets(files).setPopupTitle(SpringWebServicesBundle.message("message.dispatcher.servlet.context.choose", new Object[0])).setTooltipText(SpringWebServicesBundle.message("message.dispatcher.servlet.context", new Object[0])).setCellRenderer((PsiElementListCellRenderer)new GotoFileCellRenderer(files.size())).install(holder, (PsiElement)servlet.getServletName().getXmlTag());
        }
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        Servlet servlet;
        DomElement element;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/ws/annotators/SpringWebServiceDispatcherServletGutterAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/annotators/SpringWebServiceDispatcherServletGutterAnnotator", "annotate"));
        }
        if (psiElement instanceof XmlTag && (element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement)) instanceof Servlet && "org.springframework.ws.transport.http.MessageDispatcherServlet".equals((servlet = (Servlet)element).getServletClass().getStringValue())) {
            SpringWebServiceDispatcherServletGutterAnnotator.annotateMessageDispatcherServlet((Servlet)element, holder);
        }
    }
}

