/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.weblogicServerInstances;

import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AutoDeployUtil {
    @NonNls
    private static final String META_INF_DIR = "META-INF";
    @NonNls
    private static final String REDEPLOY_DIR = "REDEPLOY";

    private AutoDeployUtil() {
    }

    public static void autoUndeploy(CommonModel commonModel, File sourceFile) {
        File applicationsDir = AutoDeployUtil.getApplicationsDir(commonModel);
        File targetFile = new File(applicationsDir, sourceFile.getName());
        FileUtil.delete((File)targetFile);
    }

    private static File getApplicationsDir(CommonModel commonModel) {
        return ((WeblogicModel)commonModel.getServerModel()).createDomain().getApplicationsDir();
    }

    public static void autoDeploy(@NotNull CommonModel commonModel, File sourceFile) throws IOException {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/weblogic/runDebug/weblogicServerInstances/AutoDeployUtil", "autoDeploy"));
        }
        File applicationsDir = AutoDeployUtil.getApplicationsDir(commonModel);
        File targetFile = new File(applicationsDir, sourceFile.getName());
        if (sourceFile.isFile()) {
            FileUtil.copy((File)sourceFile, (File)targetFile);
        } else if (sourceFile.isDirectory()) {
            FileUtil.copyDir((File)sourceFile, (File)targetFile);
            File touchDir = new File(targetFile, META_INF_DIR);
            File touchFile = new File(touchDir, REDEPLOY_DIR);
            FileUtil.createParentDirs((File)touchFile);
            if (!touchFile.createNewFile()) {
                touchFile.setLastModified(System.currentTimeMillis());
            }
        } else {
            throw new IOException(WeblogicBundle.message("exception.text.invalid.file", sourceFile));
        }
    }
}

