/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.beaInstallation;

import com.intellij.javaee.oss.server.JavaeeInstallationConfig;
import com.intellij.javaee.oss.server.JavaeeInstallationDescriptor;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.weblogic.applicationServer.WeblogicPersistentData;
import com.intellij.javaee.weblogic.beaInstallation.Weblogic1212Installation;
import com.intellij.javaee.weblogic.beaInstallation.Weblogic9Installation;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicInstallationBase;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicVersionConfig
extends JavaeeInstallationConfig<WeblogicVersionList> {
    private static final Logger LOG = Logger.getInstance((String)("#" + WeblogicVersionConfig.class.getName()));
    private static final JavaeeInstallationConfig.Factory<JavaeePersistentData> ourFactory = new JavaeeInstallationConfig.Factory<JavaeePersistentData>(){

        @NotNull
        public JavaeeInstallationConfig<WeblogicVersionList> createConfig(JavaeePersistentData data) {
            WeblogicVersionConfig weblogicVersionConfig = new WeblogicVersionConfig();
            if (weblogicVersionConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/beaInstallation/WeblogicVersionConfig$1", "createConfig"));
            }
            return weblogicVersionConfig;
        }
    };

    public static WeblogicVersionList getVersionList(JavaeePersistentData data) throws Exception {
        return (WeblogicVersionList)WeblogicVersionConfig.get(ourFactory, (JavaeePersistentData)data);
    }

    public static WeblogicVersionList getVersionListSafe(JavaeePersistentData data) {
        try {
            return WeblogicVersionConfig.getVersionList(data);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return new WeblogicVersionList(Collections.emptyList());
        }
    }

    @Nullable
    public static WeblogicVersion getChosenVersion(JavaeePersistentData data) {
        WeblogicVersionList versionList = WeblogicVersionConfig.getVersionListSafe(data);
        return versionList.getVersionByName(((WeblogicPersistentData)data).VERSION);
    }

    protected JavaeeInstallationDescriptor<WeblogicVersionList> getInstallationDescriptor(String home) throws Exception {
        List<WeblogicInstallationBase> installations = Arrays.asList(new Weblogic9Installation(home), new Weblogic1212Installation(home));
        for (WeblogicInstallationBase installation : installations) {
            if (!installation.isValid()) continue;
            return new JavaeeInstallationDescriptor((Object)installation.getVersions(), installation.getStampFile());
        }
        throw new Exception("Weblogic installation registry file is not found");
    }
}

